package com.biz.crm.tpm.business.budget.cal.config.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @author huojia
 * @date 2022年11月02日 15:07
 */
@ApiModel(value = "BudgetCalConfigDataDto", description = "TPM-预算计算配置数据配置")
@Getter
@Setter
public class BudgetCalConfigDataVo extends TenantFlagOpVo {

    /**
     * 预算计算编码
     */
    @ApiModelProperty(value = "预算计算编码")
    private String budgetCalCode;

    /**
     * 数据配置来源编码[数据字典:tpm_cal_data_from]
     */
    @ApiModelProperty(value = "数据配置来源编码[数据字典:tpm_cal_data_from]")
    private String calDataFromCode;

    /**
     * 金额类型[数据字典:tpm_amount_type]
     */
    @ApiModelProperty(value = "金额类型[数据字典:tpm_amount_type]")
    private String amountTypeCode;

    /**
     * 客户类型[数据字典:mdm_customer_type]
     */
    @ApiModelProperty(value = "客户类型[数据字典:mdm_customer_type]")
    private String customerTypeCode;
}
