package com.biz.crm.tpm.business.budget.cal.config.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @Description 产品计费比例导入Vo
 * @Author YangWei
 * @Date 2023/2/10 上午11:05
 */
@Data
@CrmExcelImport
@EqualsAndHashCode(callSuper = true)
public class BudgetCalConfigProductRatioImportVo extends CrmExcelVo {

    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "* 产品编码")
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn(value = "* 产品名称")
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    private String productName;

    /**
     * 计费点数
     */
    @CrmExcelColumn(value = "* 计费点数")
    @ApiModelProperty(name = "计费点数", notes = "计费点数")
    private BigDecimal chargedRatio;

    /**
     * 是否扣减
     */
    @CrmExcelColumn(value = "是否扣减")
    @ApiModelProperty(name = "是否扣减", notes = "是否扣减")
    private String reduceTag;
}