package com.biz.crm.tpm.business.budget.cal.config.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author : rentao
 * @date : 2023/2/1 18:51
 */
@ApiModel(value = "BudgetCalConfigProductRatioVo", description = "TPM-预算计算配置产品计费比例")
@Getter
@Setter
public class BudgetCalConfigProductRatioVo extends TenantFlagOpVo {


  /**
   * 预算计算编码
   */
  @ApiModelProperty(name = "预算计算编码", notes = "")
  private String budgetCalCode;

  /**
   * 产品编码
   */
  @ApiModelProperty(name = "产品编码", notes = "产品编码")
  private String productCode;

  /**
   * 产品名称
   */
  @ApiModelProperty(name = "产品名称", notes = "产品名称")
  private String productName;
  /**
   * 产品品牌编码
   */
  @ApiModelProperty(name = "产品品牌编码", notes = "产品品牌编码")
  private String productBrandCode;
  /**
   * 产品品牌名称
   */
  @ApiModelProperty(name = "产品品牌名称", notes = "产品品牌名称")
  private String productBrandName;
  /**
   * 所属产品品类编码
   */
  @ApiModelProperty("所属产品品类编码")
  private String productCategoryCode;
  /**
   * 所属产品品类名称
   */
  @ApiModelProperty(name = "所属产品品类名称", notes = "所属产品品类名称")
  private String productCategoryName;
  /**
   * 产品品项编码
   */
  @ApiModelProperty("产品品项编码")
  private String productItemCode;
  /**
   * 产品品项名称
   */
  @ApiModelProperty(name = "产品品项名称", notes = "产品品项名称")
  private String productItemName;

  /**
   * 计费点数
   */
  @ApiModelProperty(name = "计费点数", notes = "计费点数")
  private BigDecimal chargedRatio;

  /**
   * 是否扣减
   */
  @ApiModelProperty(name = "是否扣减", notes = "是否扣减")
  private String reduceTag;
}
