package com.biz.crm.tpm.business.budget.cal.config.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @author huojia
 * @date 2022年11月15日 10:30
 */
@ApiModel(value = "BudgetCalConfigSalesOrgVo", description = "TPM-预算计算配置包含销售组织")
@Getter
@Setter
public class BudgetCalConfigSalesOrgVo extends TenantFlagOpVo {

    /**
     * 预算计算编码
     */
    @ApiModelProperty(value = "预算计算编码", notes = "")
    private String budgetCalCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码", notes = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称", notes = "销售组织名称")
    private String salesOrgName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(value = "销售组织层级", notes = "销售组织层级")
    private String salesLevelCode;

    /**
     * 上级销售组织编码
     */
    @ApiModelProperty(value = "上级销售组织编码", notes = "上级销售组织编码")
    private String parentSalesOrgCode;

    /**
     * 上级销售组织名称
     */
    @ApiModelProperty(value = "上级销售组织名称", notes = "上级销售组织名称")
    private String parentSalesOrgName;

}
