package com.biz.crm.tpm.business.budget.cal.config.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author huojia
 * @date 2022年11月02日 15:28
 */
@ApiModel(value = "BudgetCalConfigVo", description = "TPM-预算计算配置")
@Getter
@Setter
public class BudgetCalConfigVo extends TenantFlagOpVo {

    /**
     * 预算计算编码
     */
    @ApiModelProperty(value = "预算计算编码")
    private String budgetCalCode;

    /**
     * 预算计算名称
     */
    @ApiModelProperty(value = "预算计算名称")
    private String budgetCalName;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 预算类型[数据字典:tpm_budget_type]
     */
    @ApiModelProperty(value = "预算类型[数据字典:tpm_budget_type]")
    private String budgetTypeCode;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(name = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    /**
     * 销售组织范围[数据字典:tpm_org_area]
     */
    @ApiModelProperty(name = "销售组织范围[数据字典:tpm_org_area]", notes = "销售组织范围[数据字典:tpm_org_area]")
    private String orgAreaCode;

    /**
     * 生效起始时间
     */
    @ApiModelProperty("生效起始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date effectBeginTime;

    /**
     * 生效结束时间
     */
    @ApiModelProperty("生效结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date effectEndTime;

    /**
     * 包含销售组织集合[数据字典:tpm_org_area]
     */
    @ApiModelProperty(value = "包含销售组织集合[数据字典:tpm_org_area]", notes = "包含销售组织集合[数据字典:tpm_org_area]")
    private List<BudgetCalConfigSalesOrgVo> salesOrgList;

    /**
     * 客户非包含集合
     */
    @ApiModelProperty(value = "客户非包含集合")
    private List<BudgetCalConfigAreaVo> customerList;

    /**
     * 门店非包含集合
     */
    @ApiModelProperty(value = "门店非包含集合")
    private List<BudgetCalConfigAreaVo> terminalList;

    /**
     * 产品非包含集合
     */
    @ApiModelProperty(value = "产品非包含集合")
    private List<BudgetCalConfigAreaVo> productList;

    /**
     * 预算项目包含集合
     */
    @ApiModelProperty(value = "预算项目包含集合")
    private List<BudgetCalConfigAreaVo> budgetItemList;

    /**
     * 数据配置集合
     */
    @ApiModelProperty(value = "数据配置集合")
    private List<BudgetCalConfigDataVo> dataList;

    /**
     * 预算计算配置产品计费比例
     */
    @ApiModelProperty(value = "预算计算配置产品计费比例")
    private List<BudgetCalConfigProductRatioVo> productRatios;

    /**
     * 管控类型
     */
    @ApiModelProperty(value = "管控类型[数据字典:tpm_budget_control_type]", notes = "")
    private String controlType;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_group_code]", notes = "")
    private String groupCode;
}
