package com.biz.crm.tpm.business.budget.dimension.config.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.tpm.business.budget.dimension.config.local.service.internal.DimensionBudgetVoServiceImpl;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionBudgetDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionBudgetService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionBudgetVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.MenuDropDownBoxVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Pageable;

import javax.validation.Valid;
import java.util.*;

/**
 * (DimensionBudgetVo)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-03 18:05:57
 */
@RestController
@RequestMapping("/v1/dimensionBudget/dimensionBudget")
@Slf4j
@Api(tags = "预算维度配置")
public class DimensionBudgetController {
    /**
     * 服务对象
     */
    @Autowired
    private DimensionBudgetService dimensionBudgetService;

    /**
     * 分页查询所有数据
     *
     * @param pageable           分页对象
     * @param dimensionBudgetDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/findByConditions")
    public Result<Page<DimensionBudgetVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                            @ApiParam(name = "dimensionBudget", value = "预算维度配置表") DimensionBudgetDto dimensionBudgetDto) {
        try {
            Page<DimensionBudgetVo> page = this.dimensionBudgetService.findByConditions(pageable, dimensionBudgetDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询基础数据")
    @GetMapping("findById")
    public Result<DimensionVo> findById(@RequestParam("id") @ApiParam(name = "id", value = "主键id") String id) {
        try {
            DimensionVo dimensionVo = this.dimensionBudgetService.findById(id);
            return Result.ok(dimensionVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 新增数据
     *
     * @param dimensionDto 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<?> create(@ApiParam(name = "dimensionDto", value = "预算维度配置表") @RequestBody @Valid DimensionDto dimensionDto) {
        try {
            this.dimensionBudgetService.create(dimensionDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param dimensionDto 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "approvalCollect", value = "预算维度配置") @RequestBody @Valid DimensionDto dimensionDto) {
        try {
            this.dimensionBudgetService.update(dimensionDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @DeleteMapping
    @ApiOperation(value = "删除数据")
    public Result<?> delete(@RequestParam("ids") Set<String> ids) {
        try {
            this.dimensionBudgetService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 菜单下拉框
     *
     * @param
     * @return 删除结果
     */
    @ApiOperation(value = "菜单下拉框")
    @GetMapping("/menu/DropDownBox")
    public Result<List<MenuDropDownBoxVo>> menuDropDownBox() {
        try {
            //查询所有
            List<DimensionBudgetVo> lists = dimensionBudgetService.all();
            List<MenuDropDownBoxVo> ldnames = new ArrayList<>();

            lists.forEach(list -> {
                        ldnames.add(new MenuDropDownBoxVo(list.getId(), list.getMenu()));
                    }
            );
            Set<MenuDropDownBoxVo> treeSet = new TreeSet<MenuDropDownBoxVo>(Comparator.comparing(MenuDropDownBoxVo::getName));
            treeSet.addAll(ldnames);
            List<MenuDropDownBoxVo> ldnamesS = new ArrayList<>(treeSet);
            return Result.ok(ldnamesS);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分组类型下拉框
     *
     * @param
     * @return 删除结果
     */
    @ApiOperation(value = "分组类型下拉框")
    @GetMapping("/packetTypes/DropDownBox")
    public Result<List<MenuDropDownBoxVo>> packetTypesDownBox() {
        try {
            //查询所有
            List<DimensionBudgetVo> lists = dimensionBudgetService.all();
            List<MenuDropDownBoxVo> ldnames = new ArrayList<>();

            lists.forEach(list -> {
                        ldnames.add(new MenuDropDownBoxVo(list.getId(), list.getPacketTypes()));
                    }
            );
            Set<MenuDropDownBoxVo> treeSet = new TreeSet<MenuDropDownBoxVo>(Comparator.comparing(MenuDropDownBoxVo::getName));
            treeSet.addAll(ldnames);
            List<MenuDropDownBoxVo> ldnamesS = new ArrayList<>(treeSet);
            return Result.ok(ldnamesS);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
