package com.biz.crm.tpm.business.budget.dimension.config.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.tpm.business.budget.dimension.config.local.service.DimensionBudgetVoService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionBudgetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * (DimensionBudgetVo)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-03 17:05:57
 */
@RestController
@RequestMapping("/v1/dimensionBudget/dimensionBudgetVo")
@Slf4j
@Api(tags = "预算维度配置")
public class DimensionBudgetVoController {

    /**
     * 服务对象
     */
    @Autowired
    private DimensionBudgetVoService dimensionBudgetVoService;

    /**
     * 批量拉取 MDG 纬度数据
     * @param dto 请求参数
     * @return 纬度列表
     */
    @ApiOperation(value = "批量拉取MDG纬度数据")
    @PostMapping(value = {"/pullDimensionList"})
    public Result<?> pullDimensionList(@RequestBody MasterDataMdgBaseDto dto) {
        try {
            this.dimensionBudgetVoService.pullDimensionList(dto);
            return Result.ok("批量拉取MDG纬度数据");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}