package com.biz.crm.tpm.business.budget.dimension.config.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionBudgetDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionDimensionInformationDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * (DimensionDimensionInformationVo)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-03 17:05:57
 */
@RestController
@RequestMapping("/v1/dimensionBudget/dimensionDimensionInformation")
@Slf4j
@Api(tags = "预算维度配置")
public class DimensionDimensionInformationController {

      @Autowired
      private DimensionDimensionInformationService dimensionDimensionInformationService;

      /**
       * 通过预算维度表和销售机构查询维度信息表接口
       *
       * @param dto 对象
       */
      @ApiOperation(value = "通过预算维度表和销售机构查询维度信息表接口")
      @PostMapping
      public Result<List<DimensionDimensionInformationVo>> crfindDetailsByCodeseate(@ApiParam(name = "dto", value = "预算管控配置表") @RequestBody @Valid DimensionInformationQueryData dto) {
            try {
                  List<DimensionDimensionInformationVo> result = this.dimensionDimensionInformationService.findDetailsByCodes(dto);
                  return Result.ok(result);
            } catch (Exception e) {
                  log.error(e.getMessage(), e);
                  return Result.error(e.getMessage());
            }
      }

    /**
     * 根据登录人账号，通过菜单编码获取对应维度消息
     *
     * @param menu
     */
    @ApiOperation(value = "根据登录人账号，通过菜单编码获取对应维度消息")
    @GetMapping
    public Result<List<DimensionDimensionInformationVo>> listByMenu(@RequestParam("menu") String menu) {
        try {
            List<DimensionDimensionInformationVo> result = this.dimensionDimensionInformationService.listByMenu(menu);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 维度信息表分页查询所有数据
     *
     * @param pageable                         页对象
     * @param dimensionDimensionInformationDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "维度信息表分页查询所有数据")
    @GetMapping("/findByConditions/information")
    public Result<Page<DimensionDimensionInformationVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                          @ApiParam(name = "dimensionDimensionInformationDto", value = "维度信息表") DimensionDimensionInformationDto dimensionDimensionInformationDto) {
        try {
            Page<DimensionDimensionInformationVo> page = this.dimensionDimensionInformationService.findByConditions(pageable, dimensionDimensionInformationDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 维度信息表通过菜单查询数据分页数据
     *
     * @param pageable                         页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "维度信息表通过菜单查询数据分页数据")
    @GetMapping("/menu/query")
    public Result<Page<DimensionDimensionInformationVo>> menuByQuery(@ApiParam(name = "pageable", value = "分页对象") Pageable pageable,
                                                                           @ApiParam(name = "dimensionDimensionInformationDto", value = "维度信息表") DimensionBudgetDto dto) {
        try {
            Page<DimensionDimensionInformationVo> page = this.dimensionDimensionInformationService.menuByQuery(pageable,dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
