package com.biz.crm.tpm.business.budget.dimension.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;

/**
 * (DimensionBudget)
 *
 * @author makejava
 * @since 2022-11-05 12:00:01
 */
@ApiModel(value = "DimensionBudget", description = "预算维度表")
@Data
@Entity(name = "tpm_dimension_budget")
@org.hibernate.annotations.Table(appliesTo = "tpm_dimension_budget", comment = "预算维度表")
@TableName("tpm_dimension_budget")
@EqualsAndHashCode(callSuper = true)
public class DimensionBudget extends TenantFlagOpEntity {

    /**
     * 类型编码
     */
    @ApiModelProperty("类型编码")
    @Column(name = "type_coding", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '类型编码'")
    private String typeCoding;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业务单元'")
    private String businessUnitCode;

    /**
     * 业态
     */
    @ApiModelProperty("业态")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String businessFormatCode;

    /**
     * 分组类型
     */
    @ApiModelProperty("分组类型")
    @Column(name = "packet_types", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '分组类型'")
    private String packetTypes;

    /**
     * 菜单
     */
    @ApiModelProperty("菜单")
    @Column(name = "menu", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '菜单'")
    private String menu;

}
