package com.biz.crm.tpm.business.budget.dimension.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;

/**
 * (DimensionDimensionInformation)
 *
 * @author makejava
 * @since 2022-11-05 12:02:39
 */
@ApiModel(value = "DimensionDimensionInformation", description = "维度信息表")
@TableName("tpm_dimension_dimension_information")
@Data
@Entity(name = "tpm_dimension_dimension_information")
@org.hibernate.annotations.Table(appliesTo = "tpm_dimension_dimension_information", comment = "预算维度")
@EqualsAndHashCode(callSuper = true)

public class DimensionDimensionInformation extends UuidFlagOpEntity {

    /**
     * 类型编码
     */
    @ApiModelProperty("类型编码")
    @Column(name = "type_coding", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '类型编码'")
    private String typeCoding;
    /**
     * 字段编码
     */
    @ApiModelProperty("字段编码")
    @Column(name = "field_coding", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '字段编码'")
    private String fieldCoding;
    /**
     * 字段名称
     */
    @ApiModelProperty("字段名称")
    @Column(name = "field_name", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '字段名称'")
    private String fieldName;

    /**
     * 排序
     */
    @ApiModelProperty("排序")
    @Column(name = "sort", nullable = true, length = 20, columnDefinition = "bigint(20) COMMENT '排序'")
    private Long sort;

}
