package com.biz.crm.tpm.business.budget.dimension.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;

/**
 * (DimensionSalesOrganization)
 *
 * @author makejava
 * @since 2022-11-05 12:05:13
 */
@ApiModel(value = "DimensionSalesOrganization", description = "预算维度表")
@Data
@Entity(name = "tpm_dimension_sales_organization")
@org.hibernate.annotations.Table(appliesTo = "tpm_dimension_sales_organization", comment = "销售机构表")
@TableName("tpm_dimension_sales_organization")
@EqualsAndHashCode(callSuper = true)
public class DimensionSalesOrganization extends UuidFlagOpEntity {

    /**
     * 类型编码
     */
    @ApiModelProperty("类型编码")
    @Column(name = "type_coding", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '类型编码'")
    private String typeCoding;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_organization_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '销售机构编码'")
    private String salesOrganizationCode;

    /**
     * 销售机构名字
     */
    @ApiModelProperty("销售机构名字")
    @Column(name = "sales_organization_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '销售机构名字'")
    private String salesOrganizationName;

}
