package com.biz.crm.tpm.business.budget.dimension.config.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionBudget;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionBudgetDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionBudgetVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * (DimensionBudgetVo)表mybatis访问层
 *
 * @author makejava
 * @since 2022-11-03 17:06:06
 */
public interface DimensionBudgetMapper extends BaseMapper<DimensionBudget> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  查询实体
     * @return 所有数据
     */
    Page<DimensionBudgetVo> findByConditions(Page<DimensionBudgetVo> page,@Param("dto") DimensionBudgetDto dto);


    DimensionBudget findByIds(String id);


    /**
     * 通过对象查询预算维度表
     */
    DimensionBudget queryDimensionBudget(@Param("dto") DimensionInformationQueryData dto);

    /**
     * 查询所有字段
     */
    List<DimensionBudgetVo> all();

    /**
     * 根据菜单获取预算维度对象
     */
    DimensionBudgetVo queryTypeCoding(String typeCoding);
}

