package com.biz.crm.tpm.business.budget.dimension.config.local.notifier;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionBudgetDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionBudgetLogEventDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.event.log.DimensionBudgetLogEventListener;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.alibaba.fastjson.JSONObject;

/**
 * @author dutaotao
 * @describe:
 * @createTime 2022年06月23日 15:47:00
 */

@Component
public class DimensionBudgetLogEventListenerImpl implements DimensionBudgetLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    @Override
    public void onCreate(DimensionBudgetLogEventDto dto) {
        DimensionBudgetDto newest = dto.getNewest();
        DimensionBudgetVo original = dto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onDelete(DimensionBudgetLogEventDto dto) {
        //新对象
        DimensionBudgetDto newest = dto.getNewest();
        //旧对象
        DimensionBudgetVo original = dto.getOriginal();
        //设置主键ID
        String onlyKey = newest.getId();
        //业务日志
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        //类型代码
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        //设置唯一键键
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        //租户代码
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //设置旧对象
        crmBusinessLogDto.setOldObject(original);
        //设置新对象
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onUpdate(DimensionBudgetLogEventDto dto) {
        //新对象
        DimensionBudgetDto newest = dto.getNewest();
        // 旧对象
        DimensionBudgetVo original = dto.getOriginal();
        //主键ID
        String onlyKey = newest.getId();
        //业务日志
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        //类型代码
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        //设置唯一键键
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        //租户代码
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //设置旧对象
        crmBusinessLogDto.setOldObject(original);
        //设置新对象
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onEnable(DimensionBudgetLogEventDto dto) {
        DimensionBudgetVo original = dto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只需要传启禁用字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", EnableStatusEnum.DISABLE.getCode());
        newObject.put("enableStatus", EnableStatusEnum.ENABLE.getCode());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onDisable(DimensionBudgetLogEventDto dto) {
        //新对象
        DimensionBudgetVo original = dto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只需要传启禁用字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", EnableStatusEnum.ENABLE.getCode());
        newObject.put("enableStatus", EnableStatusEnum.DISABLE.getCode());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);

    }

}
