package com.biz.crm.tpm.business.budget.dimension.config.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionBudget;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionDimensionInformation;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionSalesOrganization;
import com.biz.crm.tpm.business.budget.dimension.config.local.mapper.DimensionBudgetMapper;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionBudgetDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionDimensionInformationDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

import java.util.List;


/**
 * (DimensionBudgetVo)表数据库访问层
 *
 * @author makejava
 * @since 2023-01-09 17:06:39
 */
@Component
public class DimensionBudgetRepository extends ServiceImpl<DimensionBudgetMapper, DimensionBudget> {

    @Autowired
    private DimensionBudgetMapper dimensionBudgetMapper;

    @Autowired
    private DimensionDimensionInformationRepository dimensionDimensionInformationRepository;

    @Autowired
    private DimensionSalesOrganizationRepository dimensionSalesOrganizationRepository;

    /**
     * 分页查询数据
     *
     * @param pageable     分页对象
     * @param dimensionDto 实体对象
     * @return
     */
    public Page<DimensionBudgetVo> findByConditions(Pageable pageable, DimensionBudgetDto dimensionDto) {
        if (pageable == null) {
            pageable = PageRequest.of(1, 50);
        }
        dimensionDto.setTenantCode(TenantUtils.getTenantCode());
        Page<DimensionBudgetVo> page = new Page<DimensionBudgetVo>(pageable.getPageNumber(), pageable.getPageSize());
        return dimensionBudgetMapper.findByConditions(page, dimensionDto);
    }

    /**
     * 根据年度预算id删除对应数据明细
     *
     * @param budgetByID
     * @author huojia
     * @date 2022/10/26 20:37
     **/
    public void deleteByYearBudgetId(String budgetByID) {

        if (StringUtils.isEmpty(budgetByID)) {
            return;
        }
        DimensionBudget dimensionBudgetData = this.getById(budgetByID);
        if (ObjectUtils.isEmpty(dimensionBudgetData)) {
            throw new RuntimeException("来源数据数据不存在！");
        }
        //根据type_coding查询字段
        List<DimensionDimensionInformation> result1 = dimensionDimensionInformationRepository.selectByTypeCoding(dimensionBudgetData.getTypeCoding());
        if (!CollectionUtils.isEmpty(result1)) {
            result1.forEach(r1 -> {
                r1.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.dimensionDimensionInformationRepository.updateBatchById(result1);
        }
        //根据type_coding查询字段
        List<DimensionSalesOrganization> result2 = dimensionSalesOrganizationRepository.selectByTypeCoding(dimensionBudgetData.getTypeCoding());
        if (!CollectionUtils.isEmpty(result2)) {
            result2.forEach(r2 -> {
                r2.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.dimensionSalesOrganizationRepository.updateBatchById(result2);
        }
    }

    /**
     * 通过对象查询预算维度表
     */
    public DimensionBudget queryDimensionBudget(DimensionInformationQueryData dto) {
        return dimensionBudgetMapper.queryDimensionBudget(dto);
    }

    /**
     * 查询所有字段
     **/
    public List<DimensionBudgetVo> all() {
        return dimensionBudgetMapper.all();
    }

    /**
     * 根据菜单获取预算维度对象
     */
    public DimensionBudgetVo queryTypeCoding(String typeCoding) {
        return dimensionBudgetMapper.queryTypeCoding(typeCoding);
    }

    /**
     * 查询预算维度表
     **/
    public DimensionBudget findByTypeCoding(String typeCoding) {
        return this.lambdaQuery().eq(DimensionBudget::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(DimensionBudget::getEnableStatus, DelFlagStatusEnum.NORMAL.getCode())
                .eq(DimensionBudget::getTenantCode, TenantUtils.getTenantCode())
                .eq(DimensionBudget::getTypeCoding, typeCoding).one();
    }

    /**
     * 根据菜单编码批量获取
     *
     * @author huojia
     * @date 2022/12/8 11:26
     * @param menuCode
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionBudget>
     **/
    public List<DimensionBudget> listByMenuCode(String menuCode) {
        if (StringUtils.isEmpty(menuCode)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(DimensionBudget::getMenu, menuCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    public List<DimensionBudget> findByTypeCodings(List<String> typeCodingList) {
        return this.lambdaQuery()
                .eq(DimensionBudget::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .in(DimensionBudget::getTypeCoding,typeCodingList)
                .list();
    }
}
