package com.biz.crm.tpm.business.budget.dimension.config.local.repository;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionDimensionInformation;
import com.biz.crm.tpm.business.budget.dimension.config.local.mapper.DimensionDimensionInformationMapper;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionDimensionInformationDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionBudgetVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;


/**
 * (DimensionDimensionInformation)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-04 16:24:59
 */
@Component
public class DimensionDimensionInformationRepository extends ServiceImpl<DimensionDimensionInformationMapper, DimensionDimensionInformation> {

    @Autowired
    private DimensionDimensionInformationMapper dimensionDimensionInformationMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 根据类型编号去查
     */
    public List<DimensionDimensionInformation> selectByTypeCoding(String typeCoding) {
        return this.lambdaQuery().eq(DimensionDimensionInformation::getTypeCoding, typeCoding).list();
    }

    /**
     * 根据类型编号去查
     */
    public DimensionDimensionInformation getTypeCoding(String typeCoding) {
        return dimensionDimensionInformationMapper.getTypeCoding(typeCoding);
    }

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return
     */
    public Page<DimensionDimensionInformationVo> findByConditions(Pageable pageable, DimensionDimensionInformationDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of(1, 50);
        }
        Page<DimensionBudgetVo> page = new Page<DimensionBudgetVo>(pageable.getPageNumber(), pageable.getPageSize());
        return dimensionDimensionInformationMapper.findByConditions(page, dto);
    }

    public Page<DimensionDimensionInformationVo> menuByQuery(Pageable pageable, DimensionDimensionInformationDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of(1, 50);
        }
        Page<DimensionBudgetVo> page = new Page<DimensionBudgetVo>(pageable.getPageNumber(), pageable.getPageSize());
        return dimensionDimensionInformationMapper.menuByQuery(page, dto);
    }

    /**
     * 批量查询
     *
     * @param typeCoding
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo>
     * @author huojia
     * @date 2022/11/23 15:53
     **/
    public List<DimensionDimensionInformationVo> listByTypeCoding(String typeCoding) {
        if (StringUtils.isEmpty(typeCoding)) {
            return null;
        }
        List<DimensionDimensionInformation> list = this.lambdaQuery()
                .eq(DimensionDimensionInformation::getTypeCoding, typeCoding).list();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return (List<DimensionDimensionInformationVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                list, DimensionDimensionInformation.class, DimensionDimensionInformationVo.class, LinkedHashSet.class, ArrayList.class
        );
    }

    /**
     * 获取单个对象
     */
    public void deleteByTypeCoding(String typeCoding) {
        if (StringUtils.isEmpty(typeCoding)) {
            return;
        }
        List<DimensionDimensionInformation> list = this.lambdaQuery().eq(DimensionDimensionInformation::getTypeCoding, typeCoding).list();
        if (!org.springframework.util.CollectionUtils.isEmpty(list)) {
            list.forEach(bimensionDimensionInformation -> {
                bimensionDimensionInformation.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 查详情
     */
    public List<DimensionDimensionInformation> selectByTypeCodingAndDelFlag(String delFlag, String typeCoding) {
        if (StringUtils.isEmpty(delFlag)) {
            return null;
        }
        return this.lambdaQuery().eq(DimensionDimensionInformation::getDelFlag, delFlag).eq(DimensionDimensionInformation::getTypeCoding, typeCoding).list();
    }

    /**
     * 批量查询
     *
     * @author huojia
     * @date 2022/12/8 13:58
     * @param typeCodeList
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionDimensionInformation>
     **/
    public List<DimensionDimensionInformation> listByTypeCodeList(List<String> typeCodeList) {
        if (CollectionUtils.isEmpty(typeCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(DimensionDimensionInformation::getTypeCoding, typeCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }
}