package com.biz.crm.tpm.business.budget.dimension.config.local.repository;


import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionDimensionInformation;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionSalesOrganization;
import com.biz.crm.tpm.business.budget.dimension.config.local.mapper.DimensionSalesOrganizationMapper;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionSalesOrganizationVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.List;


/**
 * (DimensionSalesOrganization)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-04 16:25:16
 */
@Component
public class DimensionSalesOrganizationRepository extends ServiceImpl<DimensionSalesOrganizationMapper, DimensionSalesOrganization> {

    @Autowired
    private DimensionSalesOrganizationMapper dimensionSalesOrganizationMapper;

    /**
     * 根据类型编号去查
     */
    public List<DimensionSalesOrganization> selectByTypeCoding(String delFlag) {
        return this.lambdaQuery().eq(DimensionSalesOrganization::getDelFlag, delFlag).list();
    }


    /**
     * 根据类型编号去查
     */
    public DimensionSalesOrganization getTypeCoding(String typeCoding) {
        return dimensionSalesOrganizationMapper.getTypeCoding(typeCoding);
    }

    /**
     * 根据编码类型删除预算维度字段
     */
    public void deleteByTypeCoding(String typeCoding) {
        if (StringUtils.isEmpty(typeCoding)) {
            return;
        }
        List<DimensionSalesOrganization> list = this.lambdaQuery().eq(DimensionSalesOrganization::getTypeCoding, typeCoding).list();
        if (!org.springframework.util.CollectionUtils.isEmpty(list)) {
            list.forEach(dimensionSalesOrganization -> {
                dimensionSalesOrganization.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 查详情
     */
//    public List<DimensionSalesOrganization> selectByTypeCodingAndDelFlag(String delFlag, String typeCoding) {
//        if (StringUtils.isEmpty(delFlag)) {
//            return null;
//        }
//        return this.lambdaQuery().eq(DimensionSalesOrganization::getDelFlag, delFlag).eq(DimensionSalesOrganization::getTypeCoding, typeCoding).list();
//    }

    /**
     * 批量查询
     *
     * @author huojia
     * @date 2022/12/8 11:58
     * @param typeCodeList
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionSalesOrganization>
     **/
    public List<DimensionSalesOrganization> listByTypeCodeList(List<String> typeCodeList) {
        if (CollectionUtils.isEmpty(typeCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(DimensionSalesOrganization::getTypeCoding, typeCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 查详情
     */
    public List<DimensionSalesOrganization> selectBySalesOrganization(String delFlag, String typeCoding) {
        if (StringUtils.isEmpty(delFlag)) {
            return null;
        }
        return this.lambdaQuery().eq(DimensionSalesOrganization::getDelFlag, delFlag).eq(DimensionSalesOrganization::getTypeCoding, typeCoding).list();
    }
}

