package com.biz.crm.tpm.business.budget.dimension.config.local.service.internal;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgDimensionVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgSupplierBankVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgSupplierVo;
import com.biz.crm.tpm.business.budget.dimension.config.local.constant.DimensionBudgetConstant;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionBudget;
import com.biz.crm.tpm.business.budget.dimension.config.local.repository.DimensionBudgetRepository;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.*;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.event.log.DimensionBudgetLogEventListener;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionBudgetService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionSalesOrganizationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionBudgetVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionSalesOrganizationVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.apache.commons.lang3.Validate;


/**
 * (DimensionBudgetVo)表服务实现类
 *
 * @author dutaotao
 * @since 2022-11-03 17:06:02
 */
@Slf4j
@Service("dimensionBudgetService")
public class DimensionBudgetServiceImpl implements DimensionBudgetService {

    @Autowired
    private DimensionBudgetRepository dimensionBudgetRepository;

    @Autowired
    private DimensionDimensionInformationService dimensionDimensionInformationService;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired
    private GenerateCodeService generateCodeService;

    @Autowired
    private DimensionSalesOrganizationService dimensionSalesOrganizationService;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return
     */

    @Override
    public Page<DimensionBudgetVo> findByConditions(Pageable pageable, DimensionBudgetDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of(1, 50);
        }
        if (dto == null) {
            dto = new DimensionBudgetDto();
        }
        /**获取租户编号*/
        if (StringUtils.isBlank(dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        /**获取删除标志*/
        if (StringUtils.isBlank(dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.dimensionBudgetRepository.findByConditions(pageable, dto);
    }


    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public DimensionVo findById(String id) {
        //参数效验
        if (StringUtils.isBlank(id)) {
            return null;
        }
        DimensionBudget dimensionBudget = this.dimensionBudgetRepository.getById(id);
        //根据类型编号去查
        List<DimensionDimensionInformationVo> vos = dimensionDimensionInformationService.selectByTypeCodingAndDelFlag(dimensionBudget.getDelFlag(), dimensionBudget.getTypeCoding());
        //根据类型编号去查
        List<DimensionSalesOrganizationVo> vos1 = dimensionSalesOrganizationService.selectBySalesOrganization(dimensionBudget.getDelFlag(), dimensionBudget.getTypeCoding());
        DimensionBudgetVo vo = this.nebulaToolkitService.copyObjectByWhiteList(dimensionBudget,
                DimensionBudgetVo.class,
                HashSet.class,
                ArrayList.class);
        DimensionVo dimensionVo = new DimensionVo(
                vo,
                vos,
                vos1
        );
        return dimensionVo;
    }


    /**
     * 新增数据
     *
     * @param dimensionDto 实体对象
     * @return 新增结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void create(DimensionDto dimensionDto) {
        //维度预算
        DimensionBudgetDto dimensionBudgetDto = dimensionDto.getDimensionBudgetDto();
        //维度预算信息表
        List<DimensionDimensionInformationDto> dimensionDimensionInformationDto = dimensionDto.getDimensionDimensionInformationDto();
        //维度预算销售机构表
        Validate.isTrue(!CollectionUtils.isEmpty(dimensionDto.getDimensionSalesOrganizationDto()),"销售组织至少选择一条");
        List<DimensionSalesOrganizationDto> dimensionSalesOrganizationDto = dimensionDto.getDimensionSalesOrganizationDto();
        //添加公有字段
        dimensionBudgetDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        //促销政策常量
        String ruleCode = DimensionBudgetConstant.BUDGET_DIMENSION_TABLE_PREFIX;
        String promotionCode = generateCodeService.generateCode(ruleCode, 1).get(00000);
        Validate.notBlank(promotionCode, "促销编号生成失败");
        dimensionBudgetDto.setTypeCoding(promotionCode);
        //添加租房编号
        if (StringUtils.isBlank(dimensionBudgetDto.getTenantCode())) {
            dimensionBudgetDto.setTenantCode(TenantUtils.getTenantCode());
        }
        //设置启用状态
        dimensionBudgetDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        /**保存维度预算*/
        DimensionBudget dimensionBudget = this.nebulaToolkitService.copyObjectByWhiteList(dimensionBudgetDto,
                DimensionBudget.class,
                HashSet.class,
                ArrayList.class);
        dimensionBudgetRepository.save(dimensionBudget);
        //保存预算维度信息表数据
        dimensionDimensionInformationService.save(dimensionDimensionInformationDto, promotionCode);
        //保存销售机构表数据
        dimensionSalesOrganizationService.inset(dimensionSalesOrganizationDto, promotionCode);
        DimensionBudgetVo dimensionBudgetVo = new DimensionBudgetVo();
        BeanUtils.copyProperties(dimensionBudgetVo, dimensionBudget);

        //新增业务日志
        DimensionBudgetLogEventDto logEventDto = new DimensionBudgetLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dimensionBudgetDto);
        SerializableBiConsumer<DimensionBudgetLogEventListener, DimensionBudgetLogEventDto> onCreate =
                DimensionBudgetLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, DimensionBudgetLogEventListener.class, onCreate);
    }


    /**
     * 修改数据
     *
     * @param dimensionDto 实体对象
     * @return 修改结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(DimensionDto dimensionDto) {

        //维度预算
        DimensionBudgetDto dimensionBudgetDto = dimensionDto.getDimensionBudgetDto();
        //维度预算信息表
        List<DimensionDimensionInformationDto> dimensionDimensionInformationDto = dimensionDto.getDimensionDimensionInformationDto();
        //维度预算销售机构表
        List<DimensionSalesOrganizationDto> dimensionSalesOrganizationDto = dimensionDto.getDimensionSalesOrganizationDto();
        Validate.isTrue(!CollectionUtils.isEmpty(dimensionDto.getDimensionSalesOrganizationDto()),"销售组织至少选择一条");
        DimensionBudget dimensionBudget = this.dimensionBudgetRepository.findByTypeCoding(dimensionBudgetDto.getTypeCoding());
        if (ObjectUtils.isEmpty(dimensionBudget)) {
            throw new RuntimeException("修改数据失败，原数据不存在！");
        }
        //维度预算
        DimensionBudget dimensionBudget1 = this.nebulaToolkitService.copyObjectByWhiteList(dimensionBudgetDto, DimensionBudget.class, LinkedHashSet.class, ArrayList.class);

        this.dimensionBudgetRepository.saveOrUpdate(dimensionBudget1);

        //根据编码类型删除预算维度字段
        dimensionDimensionInformationService.deleteByTypeCoding(dimensionBudgetDto.getTypeCoding());
        //批量新增维度信息表
        dimensionDimensionInformationService.savaBatch(dimensionDimensionInformationDto);

        //根据编码类型删除预算维度字段
        dimensionSalesOrganizationService.deleteByTypeCoding(dimensionBudgetDto.getTypeCoding());
        //批量新增预算维度
        dimensionSalesOrganizationService.savaBatch(dimensionSalesOrganizationDto);

        //编写业务日志
        DimensionBudgetVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(dimensionBudget, DimensionBudgetVo.class, LinkedHashSet.class, ArrayList.class);
        DimensionBudgetLogEventDto logEventDto = new DimensionBudgetLogEventDto();
        //设置原始的值
        logEventDto.setOriginal(oldVo);
        //设置新的值
        logEventDto.setNewest(dimensionBudgetDto);
        //创建可序列化的消费者在创建对象
        SerializableBiConsumer<DimensionBudgetLogEventListener, DimensionBudgetLogEventDto> onUpdate =
                DimensionBudgetLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, DimensionBudgetLogEventListener.class, onUpdate);

    }


    /**
     * 批量删除
     *
     * @param ids
     * @author huojia
     * @date 2022/11/1 21:15
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("请选择要删除的数据！");
        }
        List<DimensionBudget> dimensionBudgets = this.dimensionBudgetRepository.listByIds(ids);
        if (!CollectionUtils.isEmpty(dimensionBudgets)) {
            dimensionBudgets.forEach(dimensionBudgetVo -> {
                dimensionBudgetVo.setDelFlag(DelFlagStatusEnum.DELETE.getCode());

                //删除业务日志
                DimensionBudgetLogEventDto logEventDto = new DimensionBudgetLogEventDto();
                DimensionBudgetVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(dimensionBudgetVo, DimensionBudgetVo.class, null, null);
                logEventDto.setOriginal(oldVo);
                DimensionBudgetDto dimensionBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(dimensionBudgetVo, DimensionBudgetDto.class, null, null);
                dimensionBudgetDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                logEventDto.setNewest(dimensionBudgetDto);
                SerializableBiConsumer<DimensionBudgetLogEventListener, DimensionBudgetLogEventDto> onDelete =
                        DimensionBudgetLogEventListener::onDelete;
                this.nebulaNetEventClient.publish(logEventDto, DimensionBudgetLogEventListener.class, onDelete);
            });
            this.dimensionBudgetRepository.updateBatchById(dimensionBudgets);
            ids.forEach(budgetByID -> {
                //执行删除核销采集（主表逻辑删除，明细项信息不做变更）
                this.dimensionBudgetRepository.deleteByYearBudgetId(budgetByID);
            });
        }
    }

    private List<DimensionBudgetVo> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<DimensionBudget> approvalCollects = dimensionBudgetRepository.listByIds(ids);
        if (CollectionUtils.isEmpty(approvalCollects)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(approvalCollects, DimensionBudget.class, DimensionBudgetVo.class, HashSet.class, ArrayList.class));
    }

    /**
     * 通过对象查询预算维度表
     */
    public DimensionBudget queryDimensionBudget(DimensionInformationQueryData dto) {
        return this.dimensionBudgetRepository.queryDimensionBudget(dto);
    }

    /**
     * 查询所有字段
     **/
    @Override
    public List<DimensionBudgetVo> all() {
        return this.dimensionBudgetRepository.all();
    }

    /**
     * 根据菜单获取预算维度对象
     */
    @Override
    public DimensionBudgetVo queryTypeCoding(String typeCoding) {
        return this.dimensionBudgetRepository.queryTypeCoding(typeCoding);
    }

    /**
     * 根据菜单编码批量获取维度
     *
     * @param menuCode
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionBudgetVo>
     * @author huojia
     * @date 2022/12/8 11:24
     **/
    @Override
    public List<DimensionBudgetVo> listByMenuCode(String menuCode) {
        if (StringUtils.isEmpty(menuCode)) {
            return null;
        }
        List<DimensionBudget> dimensionBudgets = dimensionBudgetRepository.listByMenuCode(menuCode);
        if (CollectionUtils.isEmpty(dimensionBudgets)) {
            return null;
        }
        List<String> typeCodeList = dimensionBudgets.stream().map(DimensionBudget::getTypeCoding).collect(Collectors.toList());
        List<DimensionSalesOrganizationVo> dimensionSalesOrganizationList = dimensionSalesOrganizationService.listByTypeCodeList(typeCodeList);
        List<DimensionDimensionInformationVo> dimensionDimensionInformationList = dimensionDimensionInformationService.listByTypeCodeList(typeCodeList);
        Map<String, List<DimensionSalesOrganizationVo>> orgMap = new HashMap<>();
        Map<String, List<DimensionDimensionInformationVo>> informationMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(dimensionSalesOrganizationList)) {
            orgMap = dimensionSalesOrganizationList.stream()
                    .collect(Collectors.groupingBy(DimensionSalesOrganizationVo::getTypeCoding));
        }
        if (!CollectionUtils.isEmpty(dimensionDimensionInformationList)) {
            informationMap = dimensionDimensionInformationList.stream()
                    .collect(Collectors.groupingBy(DimensionDimensionInformationVo::getTypeCoding));
        }
        List<DimensionBudgetVo> result = new ArrayList<>();
        Map<String, List<DimensionSalesOrganizationVo>> finalOrgMap = orgMap;
        Map<String, List<DimensionDimensionInformationVo>> finalInformationMap = informationMap;
        dimensionBudgets.forEach(dimensionBudget -> {
            DimensionBudgetVo dimensionBudgetVo = this.nebulaToolkitService.copyObjectByWhiteList(
                    dimensionBudget, DimensionBudgetVo.class, LinkedHashSet.class, ArrayList.class
            );
            if (finalOrgMap.containsKey(dimensionBudgetVo.getTypeCoding())) {
                List<DimensionSalesOrganizationVo> dimensionSalesOrganizationVoList = finalOrgMap.get(dimensionBudgetVo.getTypeCoding());
                dimensionBudgetVo.setSalesOrgList(dimensionSalesOrganizationVoList.stream()
                        .map(DimensionSalesOrganizationVo::getSalesOrganizationCode).collect(Collectors.toList()));
            }
            if (finalInformationMap.containsKey(dimensionBudgetVo.getTypeCoding())) {
                List<DimensionDimensionInformationVo> dimensionDimensionInformationVoList = finalInformationMap.get(dimensionBudgetVo.getTypeCoding());
                dimensionBudgetVo.setInformationList(dimensionDimensionInformationVoList.stream()
                        .map(DimensionDimensionInformationVo::getFieldCoding).collect(Collectors.toList()));
            }
            result.add(dimensionBudgetVo);
        });
        return result;
    }
}