package com.biz.crm.tpm.business.budget.dimension.config.local.service.internal;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgDimensionVo;
import com.biz.crm.tpm.business.budget.dimension.config.local.constant.DimensionBudgetConstant;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionBudget;
import com.biz.crm.tpm.business.budget.dimension.config.local.repository.DimensionBudgetRepository;
import com.biz.crm.tpm.business.budget.dimension.config.local.service.DimensionBudgetVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * (DimensionBudgetVo)表服务实现类
 *
 * @author makejava
 * @since 2022-11-03 17:06:02
 */
@Slf4j
@Service("dimensionBudgetVoService")
public class DimensionBudgetVoServiceImpl implements DimensionBudgetVoService {


    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired
    private DimensionBudgetRepository dimensionBudgetRepository;


    @Autowired(required = false)
    private MasterDataMdgService masterDataMdgService;
    /**
     * 批量拉取纬度数据
     * @param dto
     * @author huojia
     * @date 2022/12/6 22:04
     **/
    @Override
    public void pullDimensionList(MasterDataMdgBaseDto dto) {
        if (ObjectUtils.isEmpty(dto)) {
            dto = new MasterDataMdgBaseDto();
        }
        if (StringUtils.isEmpty(dto.getPageNum())) {
            dto.setPageNum("1");
        }
        if (StringUtils.isEmpty(dto.getPageSize())) {
            dto.setPageSize("-1");
        }
        if (StringUtils.isEmpty(dto.getDs())) {
            dto.setDs(DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        }
        boolean lock = true;
        try {
            lock = this.lock(dto.getDs());
            if (!lock) {
                return;
            }
            List<MasterDataMdgDimensionVo> masterDataMdgDimensionVos = masterDataMdgService.pullDimensionList(dto);
            if (CollectionUtils.isEmpty(masterDataMdgDimensionVos)) {
                return;
            }
            // 数据校验
            List<DimensionBudget> pullList = this.supplierValidate(masterDataMdgDimensionVos);
            List<String> typeCodingList = pullList.stream()
                    .map(DimensionBudget::getTypeCoding).collect(Collectors.toList());
            // 区分更新、新增操作
            List<DimensionBudget> bySupplierCodes = dimensionBudgetRepository.findByTypeCodings(typeCodingList);
            if (CollectionUtils.isEmpty(bySupplierCodes)) {
                dimensionBudgetRepository.saveBatch(pullList);
                return;
            }
            // 区分更新、新增
            List<DimensionBudget> saveList = new ArrayList<>();
            List<DimensionBudget> updateList = new ArrayList<>();
            Map<String, DimensionBudget> map = bySupplierCodes.stream().collect(Collectors.toMap(DimensionBudget::getTypeCoding, Function.identity()));
            pullList.forEach(pull -> {
                if (map.containsKey(pull.getTypeCoding())) {
                    DimensionBudget dimensionBudget = map.get(pull.getTypeCoding());
                    dimensionBudget.setBusinessUnitCode(pull.getBusinessUnitCode());
                    //分组类型
                    dimensionBudget.setPacketTypes(pull.getPacketTypes());
                    //创建人名称
                    dimensionBudget.setCreateName(pull.getCreateName());
                    //修改人名称
                    dimensionBudget.setModifyName(pull.getModifyName());
                    //启用状态
                    dimensionBudget.setModifyName(pull.getModifyName());
                    dimensionBudget.setTenantCode(TenantUtils.getTenantCode());
                    dimensionBudget.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    updateList.add(dimensionBudget);
                } else {
                    saveList.add(pull);
                }
            });
            if (!CollectionUtils.isEmpty(saveList)) {
                this.dimensionBudgetRepository.saveBatch(saveList);
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                this.dimensionBudgetRepository.updateBatchById(updateList);
            }
        } finally {
            if (lock) {
                this.unLock(dto.getDs());
            }
        }
    }

    /**
     * 按年月日解锁
     *
     * @param yearMonthDay
     * @author huojia
     * @date 2022/12/6 21:52
     **/
    private void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty(yearMonthDay)) {
            throw new RuntimeException("拉取供应商解锁失败，日期不能为空！");
        }
        redisLockService.unlock(DimensionBudgetConstant.DIMENSION_LOCK  + yearMonthDay);
    }


    /**
     * 数据校验
     *
     * @param masterDataMdgDimensionVos
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionBudget>
     * @author huojia
     * @date 2022/12/6 21:37
     **/
    private List<DimensionBudget> supplierValidate(List<MasterDataMdgDimensionVo> masterDataMdgDimensionVos) {
        // 编码去重
        Map<String, String> codeMap = new HashMap<>(8);
        List<DimensionBudget> pullList = new ArrayList<>();
        masterDataMdgDimensionVos.forEach(masterDataMdgDimensionVo -> {
            if (StringUtils.isEmpty(masterDataMdgDimensionVo.getDimensionCode())) {
                log.info("本次拉取数据：" + masterDataMdgDimensionVos);
                throw new RuntimeException("纬度编码不能为空不能为空，请检查！");
            }
            if (StringUtils.isEmpty(masterDataMdgDimensionVo.getDimensionDesc())) {
                log.info("本次拉取数据：" + masterDataMdgDimensionVos);
                throw new RuntimeException("纬度名称不能为空，请检查！");
            }
            if (StringUtils.isEmpty(masterDataMdgDimensionVo.getDimensionTypeCode())) {
                log.info("本次拉取数据：" + masterDataMdgDimensionVos);
                throw new RuntimeException("纬度编码不能为空不能为空，请检查！");
            }
            DimensionBudget dimensionBudget = new DimensionBudget();
            if (codeMap.containsKey(masterDataMdgDimensionVo.getDimensionCode())) {
                log.info("本次拉取数据：" + masterDataMdgDimensionVos);
                throw new RuntimeException("编码" + masterDataMdgDimensionVo.getDimensionCode() + "重复拉取，请检查！");
            }
            codeMap.put(masterDataMdgDimensionVo.getDimensionTypeCode(), "");
            dimensionBudget.setTypeCoding(masterDataMdgDimensionVo.getDimensionCode());
            dimensionBudget.setBusinessUnitCode(masterDataMdgDimensionVo.getDimensionDesc());
            //分组类型
            dimensionBudget.setPacketTypes(masterDataMdgDimensionVo.getDimensionTypeCode());
            //创建人名称
            dimensionBudget.setCreateName(masterDataMdgDimensionVo.getObjectCreateName());
            //修改人名称
            dimensionBudget.setModifyName(masterDataMdgDimensionVo.getLastChangName());
            //启用状态
            dimensionBudget.setModifyName(masterDataMdgDimensionVo.getBlockFlag());
            dimensionBudget.setTenantCode(TenantUtils.getTenantCode());
            dimensionBudget.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            pullList.add(dimensionBudget);
        });
        return pullList;
    }

    /**
     * 按年月日加锁
     *
     * @param yearMonthDay
     * @return boolean
     * @author huojia
     * @date 2022/12/6 21:52
     **/
    private boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty(yearMonthDay)) {
            throw new RuntimeException("拉取供应商加锁失败，日期不能为空！");
        }
        return this.redisLockService.tryLock(DimensionBudgetConstant.DIMENSION_LOCK + yearMonthDay, TimeUnit.HOURS, 12);
    }

}
