package com.biz.crm.tpm.business.budget.dimension.config.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionBudget;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionDimensionInformation;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionSalesOrganization;
import com.biz.crm.tpm.business.budget.dimension.config.local.repository.DimensionDimensionInformationRepository;
import com.biz.crm.tpm.business.budget.dimension.config.local.util.ListConverterUtils;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionBudgetDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionDimensionInformationDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionSalesOrganizationDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.*;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionBudgetService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionSalesOrganizationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionSalesOrganizationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;


/**
 * (DimensionDimensionInformation)表服务实现类
 *
 * @author makejava
 * @since 2022-11-04 17:21:46
 */
@Service("dimensionDimensionInformationService")
public class DimensionDimensionInformationServiceImpl implements DimensionDimensionInformationService {

    @Autowired
    private DimensionBudgetServiceImpl dimensionBudgetService;


    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private DimensionDimensionInformationRepository dimensionDimensionInformationRepository;

    @Autowired
    private DimensionSalesOrganizationService dimensionSalesOrganizationService;

    @Override
    public List<DimensionDimensionInformationVo> findDetailsByCodes(DimensionInformationQueryData dto) {
        List<DimensionDimensionInformationVo> list = new ArrayList<>();
        if (ObjectUtils.isEmpty(dto)) {
            throw new RuntimeException("查询数据不不存在！");
        }
        // 关键指标不能为空
        if (StringUtils.isEmpty(dto.getBusinessFormatCode())
                || StringUtils.isEmpty(dto.getBusinessUnitCode())
                || StringUtils.isEmpty(dto.getMenu())
                || StringUtils.isEmpty(dto.getPacketTypes())
                || CollectionUtils.isEmpty(dto.getSalesOrgCodeList())) {
            return Lists.newArrayList();
        }

        /**
         * 通过对象查询类型编码
         * */
        DimensionBudget dimensionBudget = dimensionBudgetService.queryDimensionBudget(dto);

        /**通过编号获取DimensionDimensionInformation对象*/

        List<DimensionSalesOrganizationVo> orgs = dimensionSalesOrganizationService.listByTypeCoding(dimensionBudget.getTypeCoding());

        if (!CollectionUtils.isEmpty(orgs)) {
            List<String> orgCodeList = orgs.stream().map(DimensionSalesOrganizationVo::getSalesOrganizationCode).collect(Collectors.toList());
            if (orgCodeList.containsAll(dto.getSalesOrgCodeList())) {
                list = dimensionDimensionInformationRepository.listByTypeCoding(dimensionBudget.getTypeCoding());
            }
        }

        return list;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(List<DimensionDimensionInformationDto> dto, String promotionCode) {
        //保存预算维度信息表数据
        for (DimensionDimensionInformationDto d : dto) {
            DimensionDimensionInformation dimensionDimensionInformation = this.nebulaToolkitService.copyObjectByWhiteList(d, DimensionDimensionInformation.class, HashSet.class, ArrayList.class);
            dimensionDimensionInformation.setTypeCoding(promotionCode);
            dimensionDimensionInformationRepository.save(dimensionDimensionInformation);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public DimensionDimensionInformationVo saveOrUpdate(DimensionDimensionInformationDto dto) {
        List<DimensionDimensionInformation> formerResult = this.dimensionDimensionInformationRepository.selectByTypeCoding(dto.getTypeCoding());
        if (ObjectUtils.isEmpty(formerResult)) {
            throw new RuntimeException("修改数据失败，原数据不存在！");
        }
        DimensionDimensionInformation value = this.nebulaToolkitService.copyObjectByWhiteList(dto, DimensionDimensionInformation.class, HashSet.class, ArrayList.class);
        this.dimensionDimensionInformationRepository.saveOrUpdate(value);
        DimensionDimensionInformationVo dimensionDimensionInformationVo = this.nebulaToolkitService.copyObjectByWhiteList(dto, DimensionDimensionInformationVo.class, HashSet.class, ArrayList.class);
        return dimensionDimensionInformationVo;
    }

    /**
     * 根据编码类型删除字表字段
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByTypeCoding(String typeCoding) {
        this.dimensionDimensionInformationRepository.deleteByTypeCoding(typeCoding);
    }

    /**
     * 批量新增字表数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void savaBatch(List<DimensionDimensionInformationDto> dto) {
        for (DimensionDimensionInformationDto d : dto) {
            d.setId(null);
        }
        if (dto != null && dto.size() > 0) {
            ArrayList<DimensionDimensionInformation> productEntityList =
                    Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(dto, DimensionDimensionInformationDto.class, DimensionDimensionInformation.class, HashSet.class, ArrayList.class));
            dimensionDimensionInformationRepository.saveOrUpdateBatch(productEntityList);
        }
    }


    /**
     * 查详情
     */
    @Override
    public List<DimensionDimensionInformationVo> selectByTypeCodingAndDelFlag(String delFlag, String typeCoding) {
        List<DimensionDimensionInformation> result = this.dimensionDimensionInformationRepository.selectByTypeCodingAndDelFlag(delFlag, typeCoding);
        ListConverterUtils converterUtils = new ListConverterUtils(DimensionDimensionInformationVo.class);
        List<DimensionDimensionInformationVo> arrayList = converterUtils.converterList(result);
        return arrayList;
    }

    /**
     * 批量查询
     *
     * @param typeCodeList
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo>
     * @author huojia
     * @date 2022/12/8 13:54
     **/
    @Override
    public List<DimensionDimensionInformationVo> listByTypeCodeList(List<String> typeCodeList) {
        if (CollectionUtils.isEmpty(typeCodeList)) {
            return null;
        }
        List<DimensionDimensionInformation> dimensionDimensionInformationList = this.dimensionDimensionInformationRepository.listByTypeCodeList(typeCodeList);
        if (CollectionUtils.isEmpty(dimensionDimensionInformationList)) {
            return null;
        }
        return (List<DimensionDimensionInformationVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                dimensionDimensionInformationList, DimensionDimensionInformation.class, DimensionDimensionInformationVo.class, LinkedHashSet.class, ArrayList.class
        );
    }


    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return
     */
    @Override
    public Page<DimensionDimensionInformationVo> findByConditions(Pageable pageable, DimensionDimensionInformationDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of(1, 50);
        }

        if (dto == null) {
            dto = new DimensionDimensionInformationDto();
        }
        return this.dimensionDimensionInformationRepository.findByConditions(pageable, dto);
    }

    /**
     * 维度信息表通过菜单查询数据分页数据
     *
     * @param pageable 页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @Override
    public Page<DimensionDimensionInformationVo> menuByQuery(Pageable pageable, DimensionBudgetDto dto) {
        //定义一个集合
        if (pageable == null) {
            pageable = PageRequest.of(1, 50);
        }
        Validate.notNull(dto, "请求参数不能为空！");
        Validate.notEmpty(dto.getMenu(), "菜单编码不能为空！");

        //通过对象查询类型编码
/*        DimensionBudgetVo dimensionBudgetVo = budgetService.queryTypeCoding(dto.getTypeCoding());
        if (ObjectUtils.isEmpty(dimensionBudgetVo)) {
            throw new RuntimeException("查询数据不不存在！");
        }*/

        // 手动分页
        List<DimensionDimensionInformationVo> allList = new ArrayList<>();
        Map<String, String> fieldingMap = new HashMap<>(8);
        if (MenuCodeEnum.SALES_GOAL.getCode().equals(dto.getMenu())) {
            fieldingMap = SalesGoalEntityEnum.concertEnumToMap();
        } else if (MenuCodeEnum.SALES_PLAN.getCode().equals(dto.getMenu())) {
            fieldingMap = SalesPlanEnum.concertEnumToMap();
        } else if (MenuCodeEnum.YEAR_BUDGET.getCode().equals(dto.getMenu())) {
            fieldingMap = YearBudgetEnum.concertEnumToMap();
        }else if (MenuCodeEnum.MONTH_BUDGET.getCode().equals(dto.getMenu())) {
            fieldingMap = MonthBudgetEnum.concertEnumToMap();
        }else if (MenuCodeEnum.SUB_COM_MONTH_BUDGET.getCode().equals(dto.getMenu())) {
            fieldingMap = SubComMonthBudgetEnum.concertEnumToMap();
        }
        fieldingMap.forEach((fieldCoding, fieldName) -> {
            DimensionDimensionInformationVo dimensionDimensionInformationVo = new DimensionDimensionInformationVo();
            dimensionDimensionInformationVo.setFieldCoding(fieldCoding);
            dimensionDimensionInformationVo.setFieldName(fieldName);
            allList.add(dimensionDimensionInformationVo);
        });
        List<DimensionDimensionInformationVo> pageList = allList.stream()
                //.sorted(Comparator.comparing(DimensionDimensionInformationVo::getSort).reversed())
                .skip((long) (pageable.getPageNumber() - 1) * pageable.getPageSize())
                .limit(pageable.getPageSize()).collect(Collectors.toList());
        Page<DimensionDimensionInformationVo> page = new Page<>();
        page.setRecords(pageList);
        page.setSize(allList.size());
        page.setTotal(allList.size());
        return page;
        /*if (dimensionBudgetVo.getMenu().equals()) {
            dto.setFieldCoding(SalesGoalEntityEnum.TYPE_CODING.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.SALES_ORG_CODE.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.SALES_ORG_NAME.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.CUSTOMER_CHANNEL_CODE.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.TERMINAL_CHANNEL_NAME.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.CUSTOMER_CHANNEL_LEVEL_CODE.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.TERMINAL_CHANNEL_LEVEL_CODE.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.TERMINAL_CHANNEL_CODE.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.TERMINAL_CHANNEL_NAME.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.SYSTEM_CODE.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.SYSTEM_NAME.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.CUSTOMER_CODE.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.CUSTOMER_NAME.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.TERMINAL_CODE.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.TERMINAL_NAME.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.PRODUCT_BRAND_CODE.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.PRODUCT_BRAND_NAME.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.PRODUCT_CATEGORY_CODE.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.PRODUCT_CATEGORY_NAME.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.PRODUCT_ITEM_CODE.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.PRODUCT_ITEM_NAME.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.UNIT_CODE.getFieldCoding());
            dto.setFieldCoding(SalesGoalEntityEnum.UNIT_NAME.getFieldCoding());

            dto.setFieldCoding(SalesGoalEntityEnum.TYPE_CODING.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.SALES_ORG_CODE.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.SALES_ORG_NAME.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.CUSTOMER_CHANNEL_CODE.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.TERMINAL_CHANNEL_NAME.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.CUSTOMER_CHANNEL_LEVEL_CODE.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.TERMINAL_CHANNEL_LEVEL_CODE.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.TERMINAL_CHANNEL_CODE.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.TERMINAL_CHANNEL_NAME.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.SYSTEM_CODE.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.SYSTEM_NAME.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.CUSTOMER_CODE.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.CUSTOMER_NAME.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.TERMINAL_CODE.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.TERMINAL_NAME.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.PRODUCT_BRAND_CODE.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.PRODUCT_BRAND_NAME.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.PRODUCT_CATEGORY_CODE.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.PRODUCT_CATEGORY_NAME.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.PRODUCT_ITEM_CODE.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.PRODUCT_ITEM_NAME.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.UNIT_CODE.getFieldName());
            dto.setFieldCoding(SalesGoalEntityEnum.UNIT_NAME.getFieldName());

            DimensionDimensionInformation Information1 = this.nebulaToolkitService.copyObjectByWhiteList(dto, DimensionDimensionInformation.class, HashSet.class, ArrayList.class);
            dimensionDimensionInformationRepository.saveOrUpdate(Information1);
            voPage = this.dimensionDimensionInformationRepository.menuByQuery(pageable, dto);
        }
        return voPage;*/
    }

    /**
     * 根据登录人账号，通过菜单编码获取对应维度消息
     *
     * @param menu
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo>
     * @author huojia
     * @date 2022/11/22 19:26
     **/
    @Override
    public List<DimensionDimensionInformationVo> listByMenu(String menu) {
        Validate.notEmpty(menu, "菜单编码不能为空");
        // FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        // TODO:根据组织编码获取销售组织编码

        // 临时使用固定字段
        DimensionInformationQueryData dimensionInformationQueryData = new DimensionInformationQueryData();
        dimensionInformationQueryData.setMenu(menu);
        dimensionInformationQueryData.setSalesOrgCodeList(Lists.newArrayList("ZZ0100204"));
        dimensionInformationQueryData.setPacketTypes("sales_org");
        dimensionInformationQueryData.setBusinessUnitCode("son_company");
        dimensionInformationQueryData.setBusinessFormatCode("normal");
        List<DimensionDimensionInformationVo> dimensionInformationVos = this.findDetailsByCodes(dimensionInformationQueryData);
        return dimensionInformationVos;
    }


}
