package com.biz.crm.tpm.business.budget.dimension.config.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionDimensionInformation;
import com.biz.crm.tpm.business.budget.dimension.config.local.entity.DimensionSalesOrganization;
import com.biz.crm.tpm.business.budget.dimension.config.local.repository.DimensionSalesOrganizationRepository;
import com.biz.crm.tpm.business.budget.dimension.config.local.util.ListConverterUtils;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionDimensionInformationDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionSalesOrganizationDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionSalesOrganizationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionSalesOrganizationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * (DimensionSalesOrganization)表服务实现类
 *
 * @author makejava
 * @since 2022-11-04 16:25:16
 */
@Service("dimensionSalesOrganizationService")
public class DimensionSalesOrganizationServiceImpl implements DimensionSalesOrganizationService {

    @Autowired
    private DimensionSalesOrganizationRepository dimensionSalesOrganizationRepository;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;


    /**
     * 保存销售机构表数据
     */
    @Override
    @Transactional
    public void inset(List<DimensionSalesOrganizationDto> dto, String promotionCode) {
        //保存预算维度信息表数据
        dto.forEach(d -> {
            DimensionSalesOrganization organizationData = this.nebulaToolkitService.copyObjectByWhiteList(d, DimensionSalesOrganization.class, HashSet.class, ArrayList.class);
            organizationData.setTypeCoding(promotionCode);
            dimensionSalesOrganizationRepository.save(organizationData);
        });
    }


    /**
     * 根据类型编号去查
     */
    @Override
    public List<DimensionSalesOrganizationVo> selectByTypeCodingData(String delFlag) {
        List<DimensionSalesOrganization> result = dimensionSalesOrganizationRepository.selectByTypeCoding(delFlag);
        // 将List<User>转List<UserDto>
        ListConverterUtils converterUtils = new ListConverterUtils(DimensionSalesOrganizationVo.class);
        List<DimensionSalesOrganizationVo> arrayList = converterUtils.converterList(result);
        return arrayList;
    }

    /**
     * 保存维度预算销售机构表
     */
    @Override
    @Transactional
    public DimensionSalesOrganizationVo saveOrUpdate(DimensionSalesOrganizationDto dto) {
        List<DimensionSalesOrganizationVo> formerResult = this.selectByTypeCodingData(dto.getTypeCoding());
        if (ObjectUtils.isEmpty(formerResult)) {
            throw new RuntimeException("修改数据失败，原数据不存在！");
        }
        DimensionSalesOrganization value = this.nebulaToolkitService.copyObjectByWhiteList(dto, DimensionSalesOrganization.class, HashSet.class, ArrayList.class);
        this.dimensionSalesOrganizationRepository.saveOrUpdate(value);
        DimensionSalesOrganizationVo organizationVo = this.nebulaToolkitService.copyObjectByWhiteList(dto, DimensionSalesOrganizationVo.class, HashSet.class, ArrayList.class);
        return organizationVo;
    }


    @Override
    public List<DimensionSalesOrganizationVo> listByTypeCoding(String typeCoding) {
        if (StringUtils.isEmpty(typeCoding)) {
            return null;
        }
        List<DimensionSalesOrganization> list = this.dimensionSalesOrganizationRepository.lambdaQuery().eq(DimensionSalesOrganization::getTypeCoding, typeCoding).list();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return (List<DimensionSalesOrganizationVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                list, DimensionSalesOrganization.class, DimensionSalesOrganizationVo.class, LinkedHashSet.class, ArrayList.class
        );
    }

    /**
     * 根据编码类型删除预算维度字段
     */
    @Override
    @Transactional
    public void deleteByTypeCoding(String typeCoding) {
        this.dimensionSalesOrganizationRepository.deleteByTypeCoding(typeCoding);
    }

    /**
     * 批量新增预算维度表
     */
    @Override
    @Transactional
    public void savaBatch(List<DimensionSalesOrganizationDto> dto) {
        for (DimensionSalesOrganizationDto d : dto) {
            d.setId(null);
        }
        if (dto != null && dto.size() > 0) {
            ArrayList<DimensionSalesOrganization> productEntityList =
                    Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(dto, DimensionSalesOrganizationDto.class, DimensionSalesOrganization.class, HashSet.class, ArrayList.class));
            dimensionSalesOrganizationRepository.saveOrUpdateBatch(productEntityList);
        }
    }

//    /**
//     * 查详情
//     */
//    @Override
//    public List<DimensionSalesOrganizationVo> selectByTypeCodingAndDelFlag(String delFlag, String typeCoding) {
//        List<DimensionSalesOrganization> result = this.dimensionSalesOrganizationRepository.selectByTypeCodingAndDelFlag(delFlag, typeCoding);
//        ListConverterUtils converterUtils = new ListConverterUtils(DimensionSalesOrganizationVo.class);
//        List<DimensionSalesOrganizationVo> arrayList = converterUtils.converterList(result);
//        return arrayList;
//    }

    /**
     * 根据维度编码
     *
     * @param typeCodeList
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionSalesOrganizationVo>
     * @author huojia
     * @date 2022/12/8 11:51
     **/
    @Override
    public List<DimensionSalesOrganizationVo> listByTypeCodeList(List<String> typeCodeList) {
        if (CollectionUtils.isEmpty(typeCodeList)) {
            return null;
        }
        List<DimensionSalesOrganization> dimensionSalesOrganizationList = this.dimensionSalesOrganizationRepository.listByTypeCodeList(typeCodeList);
        if (CollectionUtils.isEmpty(dimensionSalesOrganizationList)) {
            return null;
        }
        return (List<DimensionSalesOrganizationVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                dimensionSalesOrganizationList, DimensionSalesOrganization.class, DimensionSalesOrganizationVo.class, LinkedHashSet.class, ArrayList.class
        );
    }

    /**
     * 查详情
     */
    @Override
    public List<DimensionSalesOrganizationVo> selectBySalesOrganization(String delFlag, String typeCoding) {
        List<DimensionSalesOrganization> result = this.dimensionSalesOrganizationRepository.selectBySalesOrganization(delFlag, typeCoding);
        ListConverterUtils converterUtils = new ListConverterUtils(DimensionSalesOrganizationVo.class);
        List<DimensionSalesOrganizationVo> arrayList = converterUtils.converterList(result);
        return arrayList;
    }
}


