package com.biz.crm.tpm.business.budget.dimension.config.sdk.dto;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.dto.UuidOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.persistence.Column;
import javax.validation.constraints.NotEmpty;
import java.util.Date;

/**
 * (DimensionBudget)
 *
 * @author makejava
 * @since 2022-11-04 15:19:51
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "DimensionBudget", description = "预算维度")
public class DimensionBudgetDto extends TenantFlagOpDto {

    /**
     * 类型编码
     */
    @ApiModelProperty("类型编码")
    @Column(name = "type_coding", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '类型编码'")
    private String typeCoding;


    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    @NotEmpty(message = "业务单元不能为空")
    @Column(name = "business_unit_code", nullable = true, length = 60, columnDefinition = "varchar(60) COMMENT '业务单元'")
    private String businessUnitCode;
    /**
     * 分组类型
     */
    @ApiModelProperty("分组类型")
    @NotEmpty(message = "分组类型不能为空")
    @Column(name = "packet_types", nullable = true, length = 60, columnDefinition = "varchar(60) COMMENT '分组类型'")
    private String packetTypes;
    /**
     * 菜单
     */
    @ApiModelProperty("菜单")
    @NotEmpty(message = "菜单不能为空")
    @Column(name = "menu", nullable = true, length = 65, columnDefinition = "varchar(65) COMMENT '菜单'")
    private String menu;
    /**
     * 描述
     */
    @ApiModelProperty("描述")
    @Column(name = "remark", nullable = true, length = 65, columnDefinition = "varchar(65) COMMENT '描述'")
    private String remark;
    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    @Column(name = "create_time", nullable = true, length = -1, columnDefinition = "datetime COMMENT '创建时间'")
    private Date createTime;
    /**
     * 业态
     */
    @ApiModelProperty("业态")
    @Column(name = "business_format_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '业态'")
    private String businessFormatCode;

}


