package com.biz.crm.tpm.business.budget.dimension.config.sdk.dto;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.UuidOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * (DimensionDimensionInformation)
 *
 * @author makejava
 * @since 2022-11-04 15:20:30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "DimensionBudget", description = "预算维度")
public class DimensionDimensionInformationDto extends UuidOpDto {

    /**
     * 类型编码
     */
    @ApiModelProperty("类型编码")
    @Column(name = "type_coding", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '类型编码'")
    private String typeCoding;

    /**
     * 字段编码
     */
    @ApiModelProperty("字段编码")
    @Column(name = "field_coding", nullable = true, length = 20, columnDefinition = "bigint(20) COMMENT '字段编码'")
    @NotNull(message = "字段编码不能为空")
    private String fieldCoding;

    /**
     * 字段名称
     */
    @ApiModelProperty("字段名称")
    @NotEmpty(message = "字段名称不能为空")
    @Column(name = "field_name", nullable = true, length = 60, columnDefinition = "varchar(60) COMMENT '字段名称'")
    private String fieldName;

    /**
     * 排序
     */
    @ApiModelProperty("排序")
    @Column(name = "sort", nullable = true, length = 20, columnDefinition = "bigint(20) COMMENT '排序'")
    private Long sort;

}
