package com.biz.crm.tpm.business.budget.dimension.config.sdk.dto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.validation.constraints.NotEmpty;
import java.util.List;


/**
 * (DimensionBudget)
 *
 * @author makejava
 * @since 2022-11-04 15:19:51
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "DimensionBudget", description = "维度信息查询数据")
public class DimensionInformationQueryData {
    /**
     * 业态
     */
    @ApiModelProperty("业态")
    @NotEmpty(message = "业态不能为空")
    @Column(name = "business_format_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '业态'")
    private String businessFormatCode;


    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    @NotEmpty(message = "业务单元不能为空")
    @Column(name = "business_unit_code", nullable = true, length = 60, columnDefinition = "varchar(60) COMMENT '业务单元'")
    private String businessUnitCode;



    /**
     * 菜单
     */
    @ApiModelProperty("菜单")
    @NotEmpty(message = "菜单不能为空")
    @Column(name = "menu", nullable = true, length = 65, columnDefinition = "varchar(65) COMMENT '菜单'")
    private String menu;

    /**
     * 分组类型
     */
    @ApiModelProperty("分组类型")
    @NotEmpty(message = "分组类型不能为空")
    @Column(name = "packet_types", nullable = true, length = 60, columnDefinition = "varchar(60) COMMENT '分组类型'")
    private String packetTypes;

    @ApiModelProperty("销售机构")
    private List<String> salesOrgCodeList;



}
