package com.biz.crm.tpm.business.budget.dimension.config.sdk.dto;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.UuidOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * (DimensionSalesOrganization)
 *
 * @author makejava
 * @since 2022-11-04 15:20:46
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "DimensionBudget", description = "预算维度")
public class DimensionSalesOrganizationDto extends UuidOpDto {

    /**
     * 类型编码
     */
    @ApiModelProperty("类型编码")
    @Column(name = "type_coding", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '类型编码'")
    private String typeCoding;
    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_organization_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '销售机构编码'")
    @NotEmpty(message = "销售机构编码不能为空")
    private String salesOrganizationCode;
    /**
     * 销售机构名字
     */
    @ApiModelProperty("销售机构名字")
    @Column(name = "sales_organization_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '销售机构名字'")
    @NotEmpty(message = "销售机构名字不能为空")
    private String salesOrganizationName;



}
