package com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;


/**
 * 预算维度
 */
@Getter
public enum DimensionBudgetType {
    APPROVAL("approval","活动核销"),
    COLLECT("collect","活动采集");

    DimensionBudgetType(String code, String descr){
        this.code = code;
        this.descr = descr;
    }

    private String code;

    private String descr;

    public static DimensionBudgetType findByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(DimensionBudgetType type : values()){
            if(StringUtils.equals(type.getCode(),code)){
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescr() {
        return descr;
    }

    public void setDescr(String descr) {
        this.descr = descr;
    }

}
