package com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 月度预算字段
 */
@Getter
public enum MonthBudgetEnum {

    YEAR_BUDGET_CODE("yearBudgetCode", "年度预算编码"),
    month_budget_code("monthBudgetCode", "月度预算编码"),
    BUSINESS_FORMAT_CODE("businessFormatCode", "业态"),
    BUSINESS_UNIT_CODE("businessUnitCode", "业务单元"),
    YEAR_MONTH_LY("yearMonthLy", "年月"),
    GROUP_CODE("groupCode", "分组"),
    ORG_CODE("orgCode", "组织编码"),
    ORG_NAME("orgName", "组织名称"),
    ORG_LEVEL_CODE("orgLevelCode", "组织层级"),
    BUDGET_ITEM_CODE("budgetItemCode", "预算项目编码"),
    BUDGET_ITEM_NAME("budgetItemName", "预算项目名称"),
    BUDGET_ITEM_LEVEL_CODE("budgetItemLevelCode", "预算项目层级"),
    FEE_BELONG_CODE("feeBelongCode", "费用归口"),
    SALES_ORG_CODE("salesOrgCode", "销售组织编码"),
    SALES_ORG_NAME("salesOrgName", "销售组织名称"),
    SALES_ORG_LEVEL_CODE("salesOrgLevelCode", "销售组织层级"),
    CHANNEL_CODE("channelCode", "渠道编码"),
    CHANNEL_NAME("channelName", "渠道名称"),
    CHANNEL_LEVEL_CODE("channelLevelCode", "渠道层级"),
    SYSTEM_CODE("systemCode", "系统编码"),
    SYSTEM_NAME("systemName", "系统名称"),
    CUSTOMER_CODE("customerCode", "客户编码"),
    CUSTOMER_NAME("customerName", "客户名称"),
    TERMINAL_CODE("terminalCode", "门店编码"),
    TERMINAL_NAME("terminalName", "门店名称"),
    PRODUCT_BRAND_CODE("productBrandCode", "品牌编码"),
    PRODUCT_BRAND_NAME("productBrandName", "品牌编码"),
    PRODUCT_CATEGORY_CODE("productCategoryCode", "品类编码"),
    PRODUCT_CATEGORY_NAME("productCategoryName", "品类名称"),
    PRODUCT_ITEM_CODE("productCategoryCode", "品项编码"),
    PRODUCT_ITEM_NAME("productItemName", "品项名称"),
    PRODUCT_CODE("productCode", "产品编码"),
    PRODUCT_NAME("productName", "产品名称"),
    BUDGET_TOTAL_POINT("budgetTotalPoint", "预算总点数"),

    APPROVING_AMOUNT("approvingAmount", "审批中金额）"),
    INIT_RESOLVE_AMOUNT("initResolveAmount", "年初分解金额（期初金额）"),

    FIRST_REPLY_AMOUNT("firstReplyAmount", "首次回复预算金额"),
    CAL_AMOUNT("calAmount", "计算数据"),
    FIRST_REPLY_RESOLVE_DIFF_AMOUNT("firstReplyResolveDiffAmount", "首次回复预算金额与年初分解金额"),
    LAST_MONTH_ROLLING_AMOUNT("lastMonthRollingAmount", "上月滚动金额"),
    ADJUST_AMOUNT("adjustAmount", "调整金额"),
    LAST_ACTUAL_SALES_REPLAY_DIFF_AMOUNT("lastActualSalesReplayDiffAmount", "上次实销与回复差异"),
    FREEZE_AMOUNT("freezeAmount", "冻结金额"),
    AFTER_FREEZE_AMOUNT("afterFreezeAmount", "冻结后可用金额"),
    APPROVED_AMOUNT("approvedAmount", "批复金额"),
    PRE_AUDIT_AMOUNT("preAuditAmount", "预核销金额"),
    ESTIMATED_EXCESS_AMOUNT("estimatedExcessAmount", "预估超额"),
    ACCUMULATED_AVAILABLE_BALANCE("accumulatedAvailableBalance", "累计可用余额"),
    AVAILABLE_RATIO("availableRatio", "可用费率"),
    MONTH_ROLLING_AMOUNT("monthRollingAmount", "月度滚动金额"),
    MONTH_BALANCE_AMOUNT("monthBalanceAmount", "月度结余金额"),
    PROCESS_REPLY_BUDGET_AMOUNT("processReplyBudgetAmount", "过程回复预算金额"),
    PROCESS_REPLY_RESOLVE_DIFF_AMOUNT("processReplyResolveDiffAmount", "过程回复预算与年初分解预算的差异"),
    PROCESS_REFERENCE_AMOUNT("processReferenceAmount", "过程参考可用余额"),
    PROCESS_OFFSET_AMOUNT("processOffsetAmount", "预算偏差"),
    ;

    private String fieldCoding;
    private String fieldName;

    MonthBudgetEnum(String fieldCoding, String fieldName) {
        this.fieldCoding = fieldCoding;
        this.fieldName = fieldName;
    }

    /**
     * 转换为对应map
     *
     * @return java.util.Map<java.lang.String, java.lang.String>
     * @author huojia
     * @date 2022/10/26 20:17
     **/
    public static Map<String, String> concertEnumToMap() {
        Map<String, String> map = new HashMap<>();
        for (YearBudgetEnum t : YearBudgetEnum.values()) {
            map.put(t.getFieldCoding(), t.getFieldName());
        }
        return map;
    }
}
