package com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 销售目标字段
 */
@Getter
public enum SalesGoalEntityEnum {

    BUSINESS_UNIT_CODE("businessUnitCode", "业务单元"),
    BUSINESS_FORMAT_CODE("businessFormatCode", "业态"),
    YEAR_MONTH_LY("yearMonthLy", "年月"),
    GROUP_CODE("groupCode", "分组"),
    SALES_ORG_CODE("salesOrgCode", "销售组织编码"),
    SALES_ORG_NAME("salesOrgName", "销售组织名称"),
    SALES_ORG_LEVEL_CODE("salesOrgLevelCode", "销售组织层级"),
    CUSTOMER_CHANNEL_CODE("customerChannelCode", "客户渠道编码"),
    CUSTOMER_CHANNEL_NAME("customerChannelName", "客户渠道名称"),
    CUSTOMER_CHANNEL_LEVEL_CODE("customerChannelLevelCode", "客户渠道层级"),
    TERMINAL_CHANNEL_LEVEL_CODE("terminalChannelLevelCode", "门店渠道层级"),
    TERMINAL_CHANNEL_CODE("terminalChannelCode", "门店渠道编码"),
    TERMINAL_CHANNEL_NAME("terminalChannelName", "门店渠道名称"),
    SYSTEM_CODE("systemCode", "系统编码"),
    SYSTEM_NAME("systemName", "系统名称"),
    CUSTOMER_CODE("customerCode", "客户编码"),
    CUSTOMER_NAME("customerName", "客户名称"),
    CUSTOMER_TYPE("customerType", "客户类型"),
    TERMINAL_CODE("terminalCode", "门店编码"),
    TERMINAL_NAME("terminalName", "门店名称"),
    PRODUCT_BRAND_CODE("productBrandCode", "品牌编码"),
    PRODUCT_BRAND_NAME("productBrandName", "品牌编码"),
    PRODUCT_CATEGORY_CODE("productCategoryCode", "品类编码"),
    PRODUCT_CATEGORY_NAME("productCategoryName", "品类名称"),
    PRODUCT_ITEM_CODE("productCategoryCode", "品项编码"),
    PRODUCT_ITEM_NAME("productItemName", "品项名称"),
    PRODUCT_CODE("productCode", "产品编码"),
    PRODUCT_NAME("productName", "产品名称"),
    UNIT_CODE("unitCode", "单位编码"),
    UNIT_NAME("unitName", "单位名称"),
    PRICE("price", "单价"),
    TONNAGE("tonnage", "吨位"),
    TASK_QUANTITY("taskQuantity", "任务量"),
    PURCHASE_SALES_AMOUNT("purchaseSalesAmount", "进货折前销售额"),
    DELIVERY_SALES_AMOUNT("deliverySalesAmount", "出库折前销售额"),
    DELIVERY_DISCOUNT_SALES_AMOUNT("deliveryDiscountSalesAmount", "出库折后销售额"),
    DELIVERY_QUANTITY("deliveryQuantity", "出库量");

    SalesGoalEntityEnum(String fieldCoding, String fieldName) {
        this.fieldCoding = fieldCoding;
        this.fieldName = fieldName;
    }

    private String fieldCoding;
    private String fieldName;

    /**
     * 转换为对应map
     *
     * @return java.util.Map<java.lang.String, java.lang.String>
     * @author huojia
     * @date 2022/10/26 20:17
     **/
    public static Map<String, String> concertEnumToMap() {
        Map<String, String> map = new HashMap<>();
        for (SalesGoalEntityEnum t : SalesGoalEntityEnum.values()) {
            map.put(t.getFieldCoding(), t.getFieldName());
        }
        return map;
    }
}
