package com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * TPM-分子公司月度预算字段
 * @author javadu
 */
@Getter
public enum SubComMonthBudgetEnum {
    /**
     *
     * 分子公司月度预算编码
     */
    BUSINESS_FORMAT_CODE("businessFormatCode", "业态"),
    BUSINESS_UNIT_CODE("businessUnitCode", "业务单元"),
    YEAR_MONTH_LY("yearMonthLy", "年月"),
    GROUP_CODE("groupCode", "分组"),
    budget_item_level_code("budgetItemLevelCode", "预算项目层级"),
    fee_source_code("feeSourceCode", "费用来源"),
    MONTH_BUDGET_CODE("monthBudgetCode", "分子公司月度预算编码"),
    BUDGET_ITEM_CODE("budgetItemCode", "预算项目编码"),
    ORG_LEVEL_CODE("orgLevelCode", "组织层级编码"),
    SALES_INSTITUTION_CODE("salesInstitutionCode", "销售机构编码"),
    SALES_REGION_CODE("salesRegionCode", "销售大区编码"),
    SALES_ORG_CODE("salesOrgCode", "销售组织(组)编码"),
    CHANNEL_LEVEL_CODE("channelLevelCode", "渠道层级"),
    CHANNEL_CODE("channelCode", "渠道编码"),
    SYSTEM_CODE("systemCode", "系统编码"),
    CUSTOMER_CODE("customerCode", "客户编码"),
    TERMINAL_CODE("terminalCode", "门店编码"),
    PRODUCT_BRAND_CODE("productBrandCode", "品牌编码"),
    PRODUCT_CATEGORY_CODE("productCategoryCode", "品类编码"),
    PRODUCT_ITEM_CODE("productItemCode", "品项编码"),
    PRODUCT_CODE("productCode", "产品编码");




    private String fieldCoding;
    private String fieldName;

    SubComMonthBudgetEnum(String fieldCoding, String fieldName) {
        this.fieldCoding = fieldCoding;
        this.fieldName = fieldName;
    }


    /**
     * 转换为对应map
     * @return java.util.Map<java.lang.String, java.lang.String>
     * @author huojia
     * @date 2022/10/26 20:17
     **/
    public static Map<String, String> concertEnumToMap() {
        Map<String, String> map = new HashMap<>();
        for (SubComMonthBudgetEnum t : SubComMonthBudgetEnum.values()) {
            map.put(t.getFieldCoding(), t.getFieldName());
        }
        return map;
    }

}
