package com.biz.crm.tpm.business.budget.dimension.config.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionBudgetDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionBudgetVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * (DimensionBudgetVo)表服务接口
 *
 * @author makejava
 * @since 2022-11-03 17:14:14
 */
public interface DimensionBudgetService {

    /**
     * 分页查询数据
     *
     * @param pageable           分页对象
     * @param dimensionBudgetDto 实体对象
     * @return
     */
    Page<DimensionBudgetVo> findByConditions(Pageable pageable, DimensionBudgetDto dimensionBudgetDto);


    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    DimensionVo findById(String id);


    /**
     * 新增数据
     *
     * @param dimensionDto 实体对象
     * @return 新增结果
     */
    void create(DimensionDto dimensionDto);

    /**
     * 修改数据
     *
     * @param dimensionDto 实体对象
     * @return 修改结果
     */
    void update(DimensionDto dimensionDto);


    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    void delete(Set<String> ids);

    //查询所有字段
    List<DimensionBudgetVo> all();

    /**
     * 根据菜单获取预算维度对象
     */
    DimensionBudgetVo queryTypeCoding(String typeCoding);

    /**
     * 根据菜单编码批量获取维度
     *
     * @author huojia
     * @date 2022/12/8 11:23
     * @param code
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionVo>
     **/
    List<DimensionBudgetVo> listByMenuCode(String code);
}

