package com.biz.crm.tpm.business.budget.dimension.config.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionBudgetDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionDimensionInformationDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionSalesOrganizationDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * (DimensionDimensionInformation)表服务接口
 *
 * @author makejava
 * @since 2022-11-04 16:25:58
 */
public interface DimensionDimensionInformationService {

    /**
     * 通过预算维度表和销售机构查询维度信息表接口
     *
     * @param dto 对象
     */
    List<DimensionDimensionInformationVo> findDetailsByCodes(DimensionInformationQueryData dto);

    //保存预算维度信息表数据
    void save(List<DimensionDimensionInformationDto> dimensionDimensionInformationDto, String promotionCode);


    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return
     */
    Page<DimensionDimensionInformationVo> findByConditions(Pageable pageable, DimensionDimensionInformationDto dto);

    Page<DimensionDimensionInformationVo> menuByQuery(Pageable pageable, DimensionBudgetDto dto);

    /**
     * 根据登录人账号，通过菜单编码获取对应维度消息
     *
     * @param menu
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo>
     * @author huojia
     * @date 2022/11/22 19:26
     **/
    List<DimensionDimensionInformationVo> listByMenu(String menu);


    DimensionDimensionInformationVo saveOrUpdate(DimensionDimensionInformationDto dto);

    /**
     * 根据编码类型删除字表字段
     */
    void deleteByTypeCoding(String typeCoding);

    /**
     * 批量新增
     */
    void savaBatch(List<DimensionDimensionInformationDto> dto);

    /**
     * 查详情
     */
    List<DimensionDimensionInformationVo> selectByTypeCodingAndDelFlag(String delFlag, String typeCoding);

    /**
     * 批量查询
     *
     * @author huojia
     * @date 2022/12/8 13:54
     * @param typeCodeList
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo>
     **/
    List<DimensionDimensionInformationVo> listByTypeCodeList(List<String> typeCodeList);
}

