package com.biz.crm.tpm.business.budget.dimension.config.sdk.service;


import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionDimensionInformationDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionSalesOrganizationDto;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionSalesOrganizationVo;

import java.util.List;

/**
 * (DimensionSalesOrganization)表服务接口
 *
 * @author makejava
 * @since 2022-11-04 16:25:16
 */
public interface DimensionSalesOrganizationService {

    /**
     * 保存销售机构表数据
     */
    void inset(List<DimensionSalesOrganizationDto> dto, String promotionCode);

    /**
     * 根据类型编号去查
     */
    List<DimensionSalesOrganizationVo> selectByTypeCodingData(String delFlag);


    List<DimensionSalesOrganizationVo> listByTypeCoding(String typeCoding);

    /**
     * 更新维度预算销售机构表
     */
    DimensionSalesOrganizationVo saveOrUpdate(DimensionSalesOrganizationDto dto);

    /**
     * 根据编码类型删除预算维度字段
     */
    void deleteByTypeCoding(String typeCoding);

    /**
     * 批量新增预算维度表
     */
    void savaBatch(List<DimensionSalesOrganizationDto> dto);

    /**
     * 批量查询
     *
     * @author huojia
     * @date 2022/12/8 11:50
     * @param typeCodeList
     * @return java.util.List<com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionSalesOrganizationVo>
     **/
    List<DimensionSalesOrganizationVo> listByTypeCodeList(List<String> typeCodeList);

    /**
     * 查详情
     */
    List<DimensionSalesOrganizationVo> selectBySalesOrganization(String delFlag, String typeCoding);
}

