package com.biz.crm.tpm.business.budget.dimension.config.sdk.vo;


import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

/**
 * (DimensionBudgetVo)
 *
 * @author makejava
 * @since 2022-11-03 17:07:25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "DimensionBudget", description = "预算维度")
public class DimensionBudgetVo extends TenantFlagOpVo {

    /**
     * 类型编码
     */
    @ApiModelProperty("类型编码")
    private String typeCoding;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 分组类型
     */
    @ApiModelProperty("分组类型")
    private String packetTypes;

    /**
     * 菜单
     */
    @ApiModelProperty("菜单")
    private String menu;

    /**
     * 描述
     */
    @ApiModelProperty("描述")
    private String remark;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;

    /**
     * 业态
     */
    @ApiModelProperty("业态")
    private String businessFormatCode;

    /**
     * 销售组织编码集合
     */
    @ApiModelProperty("销售组织编码集合")
    private List<String> salesOrgList;

    /**
     * 字段编码集合
     */
    @ApiModelProperty("字段编码集合")
    private List<String> informationList;

}
