package com.biz.crm.tpm.business.budget.dimension.config.sdk.vo;


import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * (DimensionSalesOrganizationVo)
 *
 * @author makejava
 * @since 2022-11-03 17:15:08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "DimensionBudget", description = "预算维度")

public class DimensionSalesOrganizationVo extends TenantFlagOpVo {
    /**
     * 类型编码
     */
    @ApiModelProperty("类型编码")
    @Column(name = "type_coding", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '类型编码'")
    private String typeCoding;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_organization_code", nullable = true, length = 60, columnDefinition = "varchar(60) COMMENT '销售机构编码'")
    private String salesOrganizationCode;
    /**
     * 销售机构名字
     */
    @ApiModelProperty("销售机构名字")
    @Column(name = "sales_organization_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '销售机构名字'")
    private String salesOrganizationName;
}
