package com.biz.crm.tpm.business.budget.discount.rate.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateConfigDimensionService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateConfigService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDimensionPageDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.DiscountRateConfigSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigDimensionVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigFormulaVariableVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/1/5 21:01
 * @description: 折扣率配置管理(DiscountRateConfig)表相关的http接口
 */
@RestController
@RequestMapping("/v1/discountRateConfig")
@Slf4j
@Api(tags = "折扣率配置管理")
public class DiscountRateConfigController {

    @Autowired(required = false)
    private DiscountRateConfigService discountRateConfigService;

    @Autowired(required = false)
    private DiscountRateConfigSdkService discountRateConfigSdkService;

    @Autowired(required = false)
    private DiscountRateConfigDimensionService discountRateConfigDimensionService;

    /**
     * 分页查询所有数据
     *
     * @param pageable  分页对象
     * @param configDto 查询dto
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<DiscountRateConfigVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "configDto", value = "折扣率配置主表Dto") DiscountRateConfigDto configDto) {
        try {
            Page<DiscountRateConfigVo> page = this.discountRateConfigSdkService.findByConditions(pageable, configDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<DiscountRateConfigVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            DiscountRateConfigVo configVo = this.discountRateConfigService.findById(id);
            return Result.ok(configVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param configDto dto对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<?> create(@ApiParam(name = "configDto", value = "折扣率配置主表Dto") @RequestBody DiscountRateConfigDto configDto) {
        try {
            this.discountRateConfigService.create(configDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param configDto dto对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "configDto", value = "折扣率配置主表Dto") @RequestBody DiscountRateConfigDto configDto) {
        try {
            this.discountRateConfigService.update(configDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping("delete")
    public Result<?> delete(@RequestParam("ids") List<String> ids) {
        try {
            this.discountRateConfigService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids 主键列表
     * @return 启用结果
     */
    @ApiOperation(value = "启用", httpMethod = "PATCH")
    @PatchMapping("/enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.discountRateConfigService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids 主键列表
     * @return 禁用结果
     */
    @ApiOperation(value = "禁用", httpMethod = "PATCH")
    @PatchMapping("/disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.discountRateConfigService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取维度信息列表
     *
     * @return List<DiscountRateConfigDimensionVo>
     */
    @ApiOperation(value = "获取维度信息列表")
    @GetMapping("/findDimension")
    public Result<Page<DiscountRateConfigDimensionVo>> findDimension(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                     @ApiParam(name = "pageDto", value = "折扣率配置维度分页Dto") DiscountRateConfigDimensionPageDto pageDto) {
        try {
            Page<DiscountRateConfigDimensionVo> page = this.discountRateConfigDimensionService.findDimension(pageable, pageDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取折扣率配置公式变量
     *
     * @param businessUnitCode 业务单元
     * @return 列表数据
     */
    @ApiOperation(value = "获取折扣率配置公式变量")
    @GetMapping("getFormulaVariable")
    public Result<List<DiscountRateConfigFormulaVariableVo>> getFormulaVariable(@RequestParam("businessUnitCode") String businessUnitCode) {
        try {
            List<DiscountRateConfigFormulaVariableVo> list = this.discountRateConfigService.getFormulaVariable(businessUnitCode);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


}
