package com.biz.crm.tpm.business.budget.discount.rate.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.SurplusFeePoolSoldBalanceService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolSoldBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.SurplusFeePoolSoldBalanceSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolSoldBalanceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/v1/surplusFeePoolSoldBalance")
@Slf4j
@Api(tags = "费用池余额+售达方分组控制层")
public class SurplusFeePoolSoldBalanceVoController {

    @Autowired(required = false)
    private SurplusFeePoolSoldBalanceSdkService surplusFeePoolSoldBalanceSdkService;

    @Autowired(required = false)
    private SurplusFeePoolSoldBalanceService surplusFeePoolSoldBalanceService;

    @ApiOperation(value = "手动调用转换数据")
    @PostMapping("handTurnData")
    public Result<?> handTurnData(@RequestBody ActivityDetailPlanItemStatisticsDto dto) {
        try {
            this.surplusFeePoolSoldBalanceService.createSurplusFeePoolSoldBalance(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "手动调用遗漏数据转换")
    @GetMapping("handRemainTurnData")
    public Result<?> handRemainTurnData() {
        try {
            this.surplusFeePoolSoldBalanceService.continueLastMonthSurplusFeePoolSoldeBalance();
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "牛e财通同步费用池余额数据")
    @GetMapping("findByConditions")
    public Result<Page<SurplusFeePoolSoldBalanceVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                      @ApiParam(name = "dto", value = "dto") SurplusFeePoolSoldBalanceDto dto) {
        try {
            Page<SurplusFeePoolSoldBalanceVo> page = this.surplusFeePoolSoldBalanceSdkService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
