package com.biz.crm.tpm.business.budget.discount.rate.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2023/1/5 10:55
 * @description: 折扣率实体类
 */
@ApiModel(value = "DiscountRate", description = "折扣率")
@TableName("tpm_discount_rate")
@Getter
@Setter
@Entity(name = "tpm_discount_rate")
@org.hibernate.annotations.Table(appliesTo = "tpm_discount_rate", comment = "折扣率")
@Table(name = "tpm_discount_rate", indexes = {
        @Index(name = "TPM_DISCOUNT_RATE_INDEX1", columnList = "discount_rate_code", unique = true)})
public class DiscountRate extends TenantFlagOpEntity {

    /**
     * 折扣率编码
     */
    @ApiModelProperty(name = "折扣率编码", notes = "折扣率编码")
    @Column(name = "discount_rate_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '折扣率编码'")
    private String discountRateCode;

    /**
     * 是否审批[数据字典:yesOrNo]
     */
    @ApiModelProperty(name = "是否审批[数据字典:yesOrNo]", notes = "是否审批[数据字典:yesOrNo]")
    @Column(name = "approve_tag", length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否审批[数据字典:yesOrNo] '")
    private String approveTag;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    @Column(name = "process_status", length = 2, columnDefinition = "VARCHAR(2) COMMENT '审批状态'")
    private String processStatus;

    /**
     * 审批流程编码
     */
    @ApiModelProperty("审批流程编码")
    @Column(name = "process_no", length = 128, columnDefinition = "VARCHAR(128) COMMENT '审批流程编码'")
    private String processNo;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 版本[数据字典:tmp_discount_rate_version]
     */
    @ApiModelProperty(name = "版本[数据字典:tmp_discount_rate_version]", notes = "版本[数据字典:tmp_discount_rate_version]")
    @Column(name = "rate_version", length = 32, columnDefinition = "VARCHAR(32) COMMENT '版本[数据字典:tmp_discount_rate_version] '")
    private String rateVersion;

    /**
     * 业务部门[数据字典:tpm_business_department]
     */
    @ApiModelProperty(name = "业务部门[数据字典:tpm_business_department]", notes = "业务部门[数据字典:tpm_business_department]")
    @Column(name = "business_department", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务部门[数据字典:tpm_business_department] '")
    private String businessDepartment;

    /**
     * 维度类型[数据字典:tpm_discount_rate_dimension]
     */
    @ApiModelProperty(name = "维度类型[数据字典:tpm_discount_rate_dimension]", notes = "维度类型[数据字典:tpm_discount_rate_dimension]")
    @Column(name = "dimension_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '维度类型[数据字典:tpm_discount_rate_dimension] '")
    private String dimensionType;

    /**
     * 区域编码
     */
    @ApiModelProperty(name = "区域编码", notes = "区域编码")
    @Column(name = "region_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码'")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(name = "区域名称", notes = "区域名称")
    @Column(name = "region_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '区域名称'")
    private String regionName;

    /**
     * 零售商编码
     */
    @ApiModelProperty(name = "零售商编码", notes = "零售商编码")
    @Column(name = "customer_retailer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '零售商编码'")
    private String customerRetailerCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "零售商名称", notes = "零售商名称")
    @Column(name = "customer_retailer_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '零售商名称'")
    private String customerRetailerName;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Column(name = "customer_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称'")
    private String customerName;

    /**
     * 客户ERP编码
     */
    @ApiModelProperty(name = "客户ERP编码", notes = "")
    @Column(name = "customer_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户ERP编码 '")
    private String customerErpCode;

    /**
     * 客户类型
     */
    @ApiModelProperty(name = "客户类型", notes = "客户类型")
    @Column(name = "customer_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户类型'")
    private String customerType;

    /**
     * MDG编码
     */
    @ApiModelProperty(name = "MDG编码", notes = "MDG编码")
    @Column(name = "mdg_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT 'MDG编码'")
    private String mdgCode;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(name = "客户渠道编码", notes = "客户渠道编码")
    @Column(name = "customer_channel_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道编码'")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(name = "客户渠道名称", notes = "客户渠道名称")
    @Column(name = "customer_channel_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户渠道名称'")
    private String customerChannelName;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    /**
     * 所属销售大区编码
     */
    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区编码 '")
    private String salesRegionCode;

    /**
     * 所属销售大区编码
     */
    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属销售大区编码 '")
    private String salesRegionName;

    /**
     * 所属销售组织(组)编码
     */
    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;

    /**
     * 所属销售组织(组)名称
     */
    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售组织(组)名称'")
    private String salesOrgName;


    /**
     * 年月
     */
    @ApiModelProperty(name = "年月", notes = "年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "year_and_month", length = 20, columnDefinition = "datetime COMMENT '年月'")
    private Date yearAndMonth;

    /**
     * 年月字符串
     */
    @ApiModelProperty(name = "年月", notes = "年月")
    @Column(name = "year_and_month_str", length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月字符串'")
    private String yearAndMonthStr;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码'")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    @Column(name = "product_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '产品名称'")
    private String productName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "品牌编码", notes = "品牌编码")
    @Column(name = "brand_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String brandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "品牌名称", notes = "品牌名称")
    @Column(name = "brand_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '品牌名称'")
    private String brandName;

    /**
     * 系统折扣率
     */
    @ApiModelProperty(name = "系统折扣率", notes = "系统折扣率")
    @Column(name = "system_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '系统折扣率'")
    private BigDecimal systemRate;

    /**
     * 系统折扣率(文本)
     */
    @ApiModelProperty(name = "系统折扣率(文本)", notes = "系统折扣率(文本)")
    @Column(name = "system_rate_str", length = 26, columnDefinition = "VARCHAR(25) COMMENT '系统折扣率(文本)'")
    private String systemRateStr;


    /**
     * 计划/修正折扣率
     */
    @ApiModelProperty(name = "计划/修正折扣率", notes = "计划/修正折扣率")
    @Column(name = "plan_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '计划/修正折扣率'")
    private BigDecimal planRate;

    /**
     * 计划/修正折扣率(文本)
     */
    @ApiModelProperty(name = "计划/修正折扣率(文本)", notes = "计划/修正折扣率(文本)")
    @Column(name = "plan_rate_str", length = 26, columnDefinition = "VARCHAR(25) COMMENT '计划/修正折扣率(文本)'")
    private String planRateStr;

    /**
     * 调整后系统折扣率
     */
    @ApiModelProperty(name = "调整后系统折扣率", notes = "调整后系统折扣率")
    @Column(name = "adjust_system_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '调整后系统折扣率'")
    private BigDecimal adjustSystemRate;

    /**
     * 调整后系统折扣率(文本)
     */
    @ApiModelProperty(name = "调整后系统折扣率(文本)", notes = "调整后系统折扣率(文本)")
    @Column(name = "adjust_system_rate_str", length = 26, columnDefinition = "VARCHAR(25) COMMENT '调整后系统折扣率(文本)'")
    private String adjustSystemRateStr;

    /**
     * 调整后计划/修正折扣率
     */
    @ApiModelProperty(name = "调整后计划/修正折扣率", notes = "调整后计划/修正折扣率")
    @Column(name = "adjust_plan_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '调整后计划/修正折扣率'")
    private BigDecimal adjustPlanRate;

    /**
     * 调整后计划/修正折扣率(文本)
     */
    @ApiModelProperty(name = "调整后计划/修正折扣率(文本)", notes = "调整后计划/修正折扣率(文本)")
    @Column(name = "adjust_plan_rate_str", length = 25, columnDefinition = "VARCHAR(25) COMMENT '计划/修正折扣率(文本)'")
    private String adjustPlanRateStr;


    /**
     * 调整后系统折扣率＞20%原因
     */
    @ApiModelProperty(name = "调整后系统折扣率＞20%原因", notes = "调整后系统折扣率＞20%原因")
    @Column(name = "adjust_reason", length = 400, columnDefinition = "VARCHAR(400) COMMENT '调整后系统折扣率＞20%原因'")
    private String adjustReason;

    /**
     * 预计上账费用
     */
    @ApiModelProperty(name = "预计上账费用", notes = "预计上账费用")
    @Column(name = "predict_account_fee", length = 24, columnDefinition = "decimal(24,6) COMMENT '预计上账费用'")
    private BigDecimal predictAccountFee;

    /**
     * 预计消化费用池费用
     */
    @ApiModelProperty(name = "预计消化费用池费用", notes = "预计消化费用池费用")
    @Column(name = "predict_digestion_fee", length = 24, columnDefinition = "decimal(24,6) COMMENT '预计消化费用池费用'")
    private BigDecimal predictDigestionFee;

    /**
     * 预计随车折扣额
     */
    @ApiModelProperty(name = "预计随车折扣额", notes = "预计随车折扣额")
    @Column(name = "predict_car_fee", length = 24, columnDefinition = "decimal(24,6) COMMENT '预计随车折扣额'")
    private BigDecimal predictCarFee;

    /**
     * 回复量
     */
    @ApiModelProperty(name = "回复量", notes = "回复量")
    @Column(name = "recovery_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '回复量'")
    private BigDecimal recoveryAmount;

    /**
     * 折扣率配置编码
     */
    @ApiModelProperty(name = "折扣率配置编码", notes = "折扣率配置编码")
    @Column(name = "config_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '折扣率配置编码'")
    private String configCode;

    /**
     * 唯一键(业态+业务单元+版本+业务部门+维度类型)
     */
    @ApiModelProperty(name = "onlyKey", notes = "唯一键(业态+业务单元+版本+业务部门+维度类型+维度编码)")
    @Column(name = "only_key", length = 256, columnDefinition = "VARCHAR(100) COMMENT '唯一键(业态+业务单元+版本+业务部门+维度类型+维度编码)'")
    private String onlyKey;

}
