package com.biz.crm.tpm.business.budget.discount.rate.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author: chenlong
 * @date: 2023/1/5 10:56
 * @description: 折扣率配置实体类
 */
@ApiModel(value = "DiscountRateConfig", description = "折扣率配置")
@TableName("tpm_discount_rate_config")
@Getter
@Setter
@Entity(name = "tpm_discount_rate_config")
@org.hibernate.annotations.Table(appliesTo = "tpm_discount_rate_config", comment = "折扣率配置")
@Table(name = "tpm_discount_rate_config", indexes = {
        @Index(name = "TPM_DISCOUNT_RATE_CONFIG_INDEX1", columnList = "config_code", unique = true)

})
public class DiscountRateConfig extends TenantFlagOpEntity {

    /**
     * 折扣率配置编码
     */
    @ApiModelProperty(name = "折扣率配置编码", notes = "折扣率配置编码")
    @Column(name = "config_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '折扣率配置编码'")
    private String configCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 版本[数据字典:tmp_discount_rate_version]
     */
    @ApiModelProperty(name = "版本[数据字典:tmp_discount_rate_version]", notes = "版本[数据字典:tmp_discount_rate_version]")
    @Column(name = "rate_version", length = 32, columnDefinition = "VARCHAR(32) COMMENT '版本[数据字典:tmp_discount_rate_version] '")
    private String rateVersion;

    /**
     * 业务部门[数据字典:tpm_business_department]
     */
    @ApiModelProperty(name = "业务部门[数据字典:tpm_business_department]", notes = "业务部门[数据字典:tpm_business_department]")
    @Column(name = "business_department", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务部门[数据字典:tpm_business_department] '")
    private String businessDepartment;

    /**
     * 维度类型[数据字典:tpm_discount_rate_dimension]
     */
    @ApiModelProperty(name = "维度类型[数据字典:tpm_discount_rate_dimension]", notes = "维度类型[数据字典:tpm_discount_rate_dimension]")
    @Column(name = "dimension_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '维度类型[数据字典:tpm_discount_rate_dimension] '")
    private String dimensionType;

    /**
     * 是否审批[数据字典:yesOrNo]
     */
    @ApiModelProperty(name = "是否审批[数据字典:yesOrNo]", notes = "是否审批[数据字典:yesOrNo]")
    @Column(name = "approve_tag", length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否审批[数据字典:yesOrNo] '")
    private String approveTag;

    /**
     * 系统折扣率计算公式
     */
    @ApiModelProperty("折扣率计算公式")
    @Column(name = "system_rate_formula", length = 100, columnDefinition = "VARCHAR(100) COMMENT '系统折扣率计算公式'")
    private String systemRateFormula;

    /**
     * 系统折扣率计算公式（展示用）
     */
    @ApiModelProperty("系统折扣率计算公式（展示用）")
    @Column(name = "system_rate_formula_name", length = 200, columnDefinition = "VARCHAR(200) COMMENT '系统折扣率计算公式（展示用）'")
    private String systemRateFormulaName;

    /**
     * 系统折扣率计算公式（json串）
     */
    @ApiModelProperty("系统折扣率计算公式（json串）")
    @Column(name = "system_rate_formula_json", length = 500, columnDefinition = "VARCHAR(500) COMMENT '系统折扣率计算公式（json串）'")
    private String systemRateFormulaJson;

    /**
     * 计划/修正折扣率计算公式
     */
    @ApiModelProperty("计划/修正折扣率计算公式")
    @Column(name = "plan_rate_formula", length = 100, columnDefinition = "VARCHAR(100) COMMENT '计划/修正折扣率计算公式'")
    private String planRateFormula;

    /**
     * 计划/修正折扣率计算公式（展示用）
     */
    @ApiModelProperty("计划/修正折扣率计算公式（展示用）")
    @Column(name = "plan_rate_formula_name", length = 200, columnDefinition = "VARCHAR(200) COMMENT '计划/修正折扣率计算公式（展示用）'")
    private String planRateFormulaName;

    /**
     * 计划/修正折扣率计算公式（json串）
     */
    @ApiModelProperty("计划/修正折扣率计算公式（json串）")
    @Column(name = "plan_rate_formula_json", length = 500, columnDefinition = "VARCHAR(500) COMMENT '计划/修正折扣率计算公式（json串）'")
    private String planRateFormulaJson;

    /**
     * 唯一键(业态+业务单元+版本+业务部门+维度类型)
     */
    @ApiModelProperty(name = "onlyKey", notes = "唯一键(业态+业务单元+版本+业务部门+维度类型)")
    @Column(name = "only_key", length = 100, columnDefinition = "VARCHAR(100) COMMENT '唯一键(业态+业务单元+版本+业务部门+维度类型)'")
    private String onlyKey;


}
