package com.biz.crm.tpm.business.budget.discount.rate.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author: chenlong
 * @date: 2023/1/5 10:56
 * @description:
 */
@ApiModel(value = "DiscountRateConfigDimension", description = "折扣率配置维度")
@TableName("tpm_discount_rate_config_dimension")
@Getter
@Setter
@Entity(name = "tpm_discount_rate_config_dimension")
@org.hibernate.annotations.Table(appliesTo = "tpm_discount_rate_config_dimension", comment = "折扣率配置维度")
@Table(name = "tpm_discount_rate_config_dimension", indexes = {
        @Index(name = "tpm_discount_rate_config_dimension_index1", columnList = "config_code", unique = false),

})
public class DiscountRateConfigDimension extends TenantFlagOpEntity {

    /**
     * 折扣率配置编码
     */
    @ApiModelProperty(name = "折扣率配置编码", notes = "折扣率配置编码")
    @Column(name = "config_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '折扣率配置编码'")
    private String configCode;

    /**
     * 字段编码
     */
    @ApiModelProperty(name = "字段编码", notes = "字段编码")
    @Column(name = "field_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '字段编码'")
    private String fieldCode;

    /**
     * 字段名称
     */
    @ApiModelProperty(name = "字段名称", notes = "字段名称")
    @Column(name = "field_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '字段编码'")
    private String fieldName;

    /**
     * 排序
     */
    @ApiModelProperty(name = "字段名称", notes = "排序")
    @Column(name = "sort", length = 20, columnDefinition = "decimal(24,6) COMMENT '排序'")
    private Integer sort;
}
