package com.biz.crm.tpm.business.budget.discount.rate.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2023/3/1 20:31
 * @description:
 */
@ApiModel(value = "SurplusFeePoolBalance", description = "剩余费用池余额")
@TableName("tpm_surplus_fee_pool_balance")
@Getter
@Setter
@Entity(name = "tpm_surplus_fee_pool_balance")
@org.hibernate.annotations.Table(appliesTo = "tpm_surplus_fee_pool_balance", comment = "剩余费用池余额")
@javax.persistence.Table(name = "tpm_surplus_fee_pool_balance", indexes = {
        @Index(name = "TPM_FEE_POOL_BALANCE_INDEX1", columnList = "only_key",unique = true)})
public class SurplusFeePoolBalance extends TenantFlagOpEntity {

    /**
     * 剩余费用池余额
     */
    @ApiModelProperty(value = "balance", name = "剩余费用池余额", notes = "剩余费用池余额")
    @Column(name = "balance", length = 24, columnDefinition = "decimal(24,6) COMMENT '剩余费用池余额'")
    private BigDecimal balance;

    /**
     * 年月
     */
    @ApiModelProperty(value = "year_month_str", name = "年月", notes = "年月")
    @Column(name = "year_month_str", length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月'")
    private String yearMonthStr;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 零售商编码
     */
    @ApiModelProperty(value = "customerRetailerCode", name = "零售商编码", notes = "零售商编码")
    @Column(name = "customer_retailer_code", length = 32, columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String customerRetailerCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty(value = "customer_retailer_name", name = "零售商名称", notes = "零售商名称")
    @Column(name = "customer_retailer_name", length = 256, columnDefinition = "varchar(256) COMMENT '零售商名称'")
    private String customerRetailerName;

    /**
     * 区域编码
     */
    @ApiModelProperty(value = "regionCode", name = "区域编码", notes = "区域编码")
    @Column(name = "region_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码'")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(value = "regionName", name = "区域名称", notes = "区域名称")
    @Column(name = "region_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '区域名称'")
    private String regionName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "brandCode", name = "品牌编码", notes = "品牌编码")
    @Column(name = "brand_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String brandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "brandName", name = "品牌名称", notes = "品牌名称")
    @Column(name = "brand_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '品牌名称'")
    private String brandName;

    /**
     * 唯一键(业态+业务单元+零售商+区域+品牌+年月),-隔开
     */
    @ApiModelProperty(name = "onlyKey", notes = "唯一键(业态+业务单元+零售商+区域+品牌+年月)-隔开")
    @Column(name = "only_key", length = 256, columnDefinition = "VARCHAR(100) COMMENT '唯一键(业态+业务单元+零售商+区域+品牌+年月)-隔开'")
    private String onlyKey;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionErpCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;
}
