package com.biz.crm.tpm.business.budget.discount.rate.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import java.math.BigDecimal;

@ApiModel(value = "SurplusFeePoolSoldBalance", description = "剩余费用池余额(分组加售达方)")
@TableName("tpm_surplus_fee_pool_sold_balance")
@Data
@Entity(name = "tpm_surplus_fee_pool_sold_balance")
@org.hibernate.annotations.Table(appliesTo = "tpm_surplus_fee_pool_sold_balance", comment = "剩余费用池余额(分组加售达方)")
@javax.persistence.Table(name = "tpm_surplus_fee_pool_sold_balance", indexes = {
        @Index(name = "tpm_surplus_fee_pool_sold_balance_index1", columnList = "only_key",unique = true)})
public class SurplusFeePoolSoldBalance extends TenantFlagOpEntity {

    @ApiModelProperty("剩余费用池余额")
    @Column(name = "balance", length = 24, columnDefinition = "decimal(24,6) default 0 COMMENT '剩余费用池余额'")
    private BigDecimal balance;

    @ApiModelProperty("年月")
    @Column(name = "year_month_str", length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月'")
    private String yearMonthStr;

    @ApiModelProperty("业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    @ApiModelProperty("业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    @ApiModelProperty("零售商编码")
    @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String systemCode;

    @ApiModelProperty("零售商名称")
    @Column(name = "system_name", length = 256, columnDefinition = "varchar(256) COMMENT '零售商名称'")
    private String systemName;

    @ApiModelProperty("区域编码")
    @Column(name = "region_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码'")
    private String regionCode;

    @ApiModelProperty("区域名称")
    @Column(name = "region_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '区域名称'")
    private String regionName;

    @ApiModelProperty("唯一键(业态+业务单元+零售商+区域+售达方+年月)-隔开")
    @Column(name = "only_key", length = 256, columnDefinition = "VARCHAR(100) COMMENT '唯一键(业态+业务单元+零售商+售达方+年月)-隔开'")
    private String onlyKey;

    @ApiModelProperty("售达方编码")
    @Column(name = "sold_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '售达方编码'")
    private String soldCode;

    @ApiModelProperty("父级onlyKey")
    @Column(name = "parent_only_key", length = 64, columnDefinition = "VARCHAR(100) COMMENT '父级onlyKey'")
    private String parentOnlyKey;

}
