package com.biz.crm.tpm.business.budget.discount.rate.local.listener;

import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.constant.DiscountRateConstant;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 折扣率审批通过回调
 *
 * @author chenlong
 * @date 2023/01/09 11:02
 */
@Component
public class DiscountRateProcessCompleteListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private DiscountRateService discountRateService;

    @Override
    public String getBusinessCode() {
        return DiscountRateConstant.DISCOUNT_RATE_PROCESS;
    }

    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        if (StringUtils.isEmpty(dto.getBusinessNo())) {
            return;
        }
        //多策略提交
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");
        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            discountRateService.processPass(dto);
        }
        //审批驳回|流程追回
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ||
                ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            discountRateService.processRejectAndRecover(dto);
        }
    }
}
