package com.biz.crm.tpm.business.budget.discount.rate.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfig;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigVo;
import org.apache.ibatis.annotations.Param;

/**
 * @author: chenlong
 * @date: 2023/1/5 19:22
 * @description: 折扣率配置表(DiscountRateConfig)表mybatis访问层
 */

public interface DiscountRateConfigMapper extends BaseMapper<DiscountRateConfig> {

    /**
     * 分页查询所有数据
     *
     * @param page      分页对象
     * @param configDto 查询Dto
     * @return 所有数据
     */
    Page<DiscountRateConfigVo> findByConditions(@Param("page") Page<DiscountRateConfigVo> page, @Param("dto") DiscountRateConfigDto configDto);
}
