package com.biz.crm.tpm.business.budget.discount.rate.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRate;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRatePlanCalDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/1/5 19:21
 * @description: 折扣率表(DiscountRate)表mybatis访问层
 */
public interface DiscountRateMapper extends BaseMapper<DiscountRate> {

    /**
     * 分页查询所有数据
     *
     * @param page    分页对象
     * @param rateDto 查询Dto
     * @return 所有数据
     */
    Page<DiscountRateVo> findByConditions(@Param("page") Page<DiscountRateVo> page, @Param("dto") DiscountRateDto rateDto);

    /**
     * 大批量保存
     *
     * @param entities 数据列表
     */
    void bulkSave(@Param("rates") List<DiscountRate> entities);


    /**
     * 根据业态+业务单元+客户+产品组装的key获取折扣率
     *
     * @param keys       分页对象
     * @param tenantCode 租户
     * @return List<DiscountRateDto>
     */
    List<DiscountRateDto> getDiscountRateByKeys(@Param("keys") List<List<String>> keys, @Param("tenantCode") String tenantCode);

    /**
     * 根据业态+业务单元+客户组装的key获取折扣率
     *
     * @param keys       分页对象
     * @param tenantCode 租户
     * @return List<DiscountRateDto>
     */
    List<DiscountRateDto> getDiscountRateByKeysNoPro(@Param("keys") List<List<String>> keys, @Param("tenantCode") String tenantCode);

    /**
     * 销售计划获取折扣率
     *
     * @param dto 筛选数据
     * @return List < DiscountRateDto>
     */
    List<DiscountRateDto> findRateByPlanConditions(@Param("dto")DiscountRatePlanCalDto dto);

    /**
     * 根据onlykeys获取id
     *
     * @param keyList onlyKey列表
     * @return List<DiscountRate>
     */
    List<DiscountRate> getIdByKeys(@Param("keyList") List<List<String>> keyList, @Param("tenantCode") String tenantCode);
}
