package com.biz.crm.tpm.business.budget.discount.rate.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.SurplusFeePoolBalance;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolBalanceVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/3/2 9:57
 * @description: 剩余费用池余额表mybatis访问层
 */
public interface SurplusFeePoolBalanceMapper extends BaseMapper<SurplusFeePoolBalance> {

    /**
     * 获取剩余费用池余额通过onlyKeys
     *
     * @param keyList    onlyKey列表
     * @param tenantCode 租户
     * @return 列表数据
     */
    List<SurplusFeePoolBalanceVo> getPoolBalanceByOnlyKeys(@Param("keyList") List<List<String>> keyList, @Param("tenantCode") String tenantCode);

    /**
     * 获取剩余费用池余额
     *
     * @param dto 参数
     * @return Map<String, BigDecimal>
     */
    List<SurplusFeePoolBalanceVo> getAmountByDate(@Param("dto") SurplusFeePoolBalanceDto dto, @Param("tenantCode") String tenantCode);

    /**
     * 费用池余额表报表年月的期初余额
     * @param balanceDtos
     * @param code
     * @param tenantCode
     * @return
     */
    List<SurplusFeePoolBalanceVo> findListForFR(@Param("dtos") List<SurplusFeePoolBalanceDto> balanceDtos,@Param("code") String code,@Param("tenantCode") String tenantCode);
}
