package com.biz.crm.tpm.business.budget.discount.rate.local.notifier.log;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateLogEventDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.event.log.DiscountRateEventListener;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2023/1/6 11:00
 * @description: 折扣率管理日志监听实现类
 */
@Component
public class DiscountRateEventListenerImpl implements DiscountRateEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 创建事件
     *
     * @param eventDto 事件dto
     */
    @Override
    public void onCreate(DiscountRateLogEventDto eventDto) {
        DiscountRateDto newest = eventDto.getNewest();
        DiscountRateVo original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 删除事件
     *
     * @param eventDto 事件dto
     */
    @Override
    public void onDelete(DiscountRateLogEventDto eventDto) {
        DiscountRateDto newest = eventDto.getNewest();
        DiscountRateVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 更新日志
     *
     * @param eventDto 事件dto
     */
    @Override
    public void onUpdate(DiscountRateLogEventDto eventDto) {
        DiscountRateDto newest = eventDto.getNewest();
        DiscountRateVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 启用
     *
     * @param eventDto 事件dto
     */
    @Override
    public void onEnable(DiscountRateLogEventDto eventDto) {
        DiscountRateDto newest = eventDto.getNewest();
        DiscountRateVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只传单个字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", original.getEnableStatus());
        newObject.put("enableStatus", newest.getEnableStatus());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 禁用
     *
     * @param eventDto 事件dto
     */
    @Override
    public void onDisable(DiscountRateLogEventDto eventDto) {
        DiscountRateDto newest = eventDto.getNewest();
        DiscountRateVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只传单个字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", original.getEnableStatus());
        newObject.put("enableStatus", newest.getEnableStatus());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
