package com.biz.crm.tpm.business.budget.discount.rate.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2023/1/6 11:17
 * @description: 折扣率配置管理数据视图
 */
@Component
@Slf4j
public class DiscountRateConfigDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_discount_rate_config_data_view";
    }

    @Override
    public String desc() {
        return "TPM-折扣率配置管理";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_discount_rate_config t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }
}
