package com.biz.crm.tpm.business.budget.discount.rate.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2023/1/6 11:17
 * @description: 折扣率管理数据视图
 */
@Component
@Slf4j
public class DiscountRateDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_discount_rate_data_view";
    }

    @Override
    public String desc() {
        return "TPM-折扣率管理";
    }

    @Override
    public String buildSql() {
        return " select a.id ," +
                "a.plan_rate_str," +
                "a.config_code," +
                "a.rate_version," +
                "a.customer_name," +
                "a.customer_erp_code," +
                "a.sales_org_name," +
                "a.approve_tag," +
                "a.enable_status," +
                "a.customer_code," +
                "a.del_flag," +
                "a.sales_region_code," +
                "a.sales_institution_code," +
                "a.customer_retailer_name," +
                "a.tenant_code," +
                "a.region_code," +
                "a.product_code," +
                "a.sales_institution_name," +
                "a.remark," +
                "a.sales_region_name," +
                "a.adjust_plan_rate_str," +
                "a.process_status," +
                "a.customer_type," +
                "a.adjust_reason," +
                "a.adjust_system_rate_str," +
                "a.modify_account," +
                "a.mdg_code," +
                "a.product_name," +
                "a.brand_name," +
                "a.create_account," +
                "a.create_name," +
                "a.system_rate_str," +
                "a.only_key," +
                "a.customer_channel_name," +
                "a.customer_channel_code," +
                "a.discount_rate_code," +
                "a.dimension_type," +
                "a.sales_org_code," +
                "a.business_format_code," +
                "a.year_and_month," +
                "a.region_name," +
                "a.brand_code," +
                "a.process_no," +
                "a.business_department," +
                "a.customer_retailer_code," +
                "a.create_time," +
                "a.business_unit_code," +
                "a.modify_name," +
                "a.modify_time," +
                "a.year_and_month_str," +
                "TRUNCATE(a.system_rate, 3) as system_rate," +
                "TRUNCATE(a.plan_rate, 3) as plan_rate," +
                "TRUNCATE(a.adjust_system_rate, 3) as adjust_system_rate," +
                "TRUNCATE(a.adjust_plan_rate, 3) as adjust_plan_rate," +
                "TRUNCATE(a.predict_account_fee, 3) as predict_account_fee," +
                "TRUNCATE(a.predict_digestion_fee, 3) as predict_digestion_fee," +
                "TRUNCATE(a.predict_car_fee, 3) as predict_car_fee," +
                "TRUNCATE(a.recovery_amount, 3) as recovery_amount" +
                " from tpm_discount_rate a " +
                "where a.tenant_code = :tenantCode " +
                "and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }
}
