package com.biz.crm.tpm.business.budget.discount.rate.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2023/3/2 10:03
 * @description: 剩余费用池余额数据视图
 */
@Component
@Slf4j
public class SurplusFeePoolBalanceDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_surplus_fee_pool_balance_data_view";
    }

    @Override
    public String desc() {
        return "TPM-折扣率-剩余费用池余额";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_surplus_fee_pool_balance t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }
}
