package com.biz.crm.tpm.business.budget.discount.rate.local.repository;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfig;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfigDimension;
import com.biz.crm.tpm.business.budget.discount.rate.local.mapper.DiscountRateConfigDimensionMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/1/5 19:29
 * @description: 电折扣率配置维度表(DiscountRateConfigDimension)表数据库访问层
 */
@Component
public class DiscountRateConfigDimensionRepository extends ServiceImpl<DiscountRateConfigDimensionMapper, DiscountRateConfigDimension> {

    @Autowired(required = false)
    private DiscountRateConfigDimensionMapper discountRateConfigDimensionMapper;

    /**
     * 重构批量修改方法
     *
     * @param entitys    实体类集合
     * @param tenantCode 租户编码
     */
    public void updateBatchByIdAndTenantCode(Collection<DiscountRateConfigDimension> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty(tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank(item.getId())) {
                LambdaUpdateWrapper<DiscountRateConfigDimension> lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(DiscountRateConfigDimension::getTenantCode, tenantCode);
                lambdaUpdateWrapper.eq(DiscountRateConfigDimension::getId, item.getId());
                this.baseMapper.update(item, lambdaUpdateWrapper);
            }
        });
    }
}
