package com.biz.crm.tpm.business.budget.discount.rate.local.repository;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfig;
import com.biz.crm.tpm.business.budget.discount.rate.local.mapper.DiscountRateConfigMapper;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;

/**
 * @author: chenlong
 * @date: 2023/1/5 19:34
 * @description: 折扣率配置(DiscountRateConfig)表数据库访问层
 */
@Component
public class DiscountRateConfigRepository extends ServiceImpl<DiscountRateConfigMapper, DiscountRateConfig> {

    @Autowired(required = false)
    private DiscountRateConfigMapper discountRateConfigMapper;

    /**
     * 重构修改方法
     *
     * @param entity     实体类
     * @param tenantCode 租户编码
     */
    public void updateByIdAndTenantCode(DiscountRateConfig entity, String tenantCode) {
        LambdaUpdateWrapper<DiscountRateConfig> lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(DiscountRateConfig::getTenantCode, tenantCode);
        lambdaUpdateWrapper.eq(DiscountRateConfig::getId, entity.getId());
        this.baseMapper.update(entity, lambdaUpdateWrapper);
    }


    /**
     * 重构批量修改方法
     *
     * @param entitys    实体类集合
     * @param tenantCode 租户编码
     */
    public void updateBatchByIdAndTenantCode(Collection<DiscountRateConfig> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty(tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank(item.getId())) {
                LambdaUpdateWrapper<DiscountRateConfig> lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(DiscountRateConfig::getTenantCode, tenantCode);
                lambdaUpdateWrapper.eq(DiscountRateConfig::getId, item.getId());
                this.baseMapper.update(item, lambdaUpdateWrapper);
            }
        });
    }

    /**
     * 分页查询数据
     *
     * @param pageable  分页对象
     * @param configDto 查询Dto
     * @return Page<DiscountRateConfigVo>
     */
    public Page<DiscountRateConfigVo> findByConditions(Pageable pageable, DiscountRateConfigDto configDto) {
        Page<DiscountRateConfigVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.discountRateConfigMapper.findByConditions(page, configDto);
    }
}
